/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.glwallpaperservice;

import android.annotation.SuppressLint;
import android.content.Context;
import android.opengl.GLSurfaceView;
import android.service.wallpaper.WallpaperService;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.SurfaceHolder;

public abstract class GLWallpaperService
extends WallpaperService {
    private static final String TAG = "GLWallpaperService";

    protected abstract GLEngine createGLEngine();

    public final WallpaperService.Engine onCreateEngine() {
        return this.createGLEngine();
    }

    @SuppressLint(value={"ViewConstructor"})
    public static class GLWallpaperSurfaceView
    extends GLSurfaceView {
        private final WallpaperService.Engine mEngine;

        public GLWallpaperSurfaceView(@NonNull Context context, @NonNull WallpaperService.Engine engine) {
            super(context);
            this.mEngine = engine;
            this.getHolder().removeCallback((SurfaceHolder.Callback)this);
        }

        public SurfaceHolder getHolder() {
            if (this.mEngine != null && this.mEngine.getSurfaceHolder() != null) {
                return this.mEngine.getSurfaceHolder();
            }
            return super.getHolder();
        }

        public void onDestroy() {
            super.onDetachedFromWindow();
        }
    }

    public abstract class GLEngine
    extends WallpaperService.Engine {
        private final GLWallpaperSurfaceView mGLSurfaceView;

        public GLEngine() {
            super((WallpaperService)GLWallpaperService.this);
            this.mGLSurfaceView = new GLWallpaperSurfaceView((Context)GLWallpaperService.this, this);
        }

        protected abstract void setupGLSurfaceView(boolean var1);

        @CallSuper
        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            Log.d((String)GLWallpaperService.TAG, (String)("onCreate:" + (Object)((Object)this) + ", surfaceHolder=" + surfaceHolder));
        }

        @CallSuper
        public void onSurfaceCreated(SurfaceHolder holder) {
            super.onSurfaceCreated(holder);
            Log.d((String)GLWallpaperService.TAG, (String)("onSurfaceCreated:" + (Object)((Object)this) + ", surfaceHolder=" + holder));
            this.setupGLSurfaceView(this.isPreview());
            this.mGLSurfaceView.surfaceCreated(holder);
        }

        @CallSuper
        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            super.onSurfaceChanged(holder, format, width, height);
            Log.d((String)GLWallpaperService.TAG, (String)("onSurfaceChanged:" + (Object)((Object)this) + ", width=" + width + ", height=" + height + ", surfaceHolder=" + holder));
            this.mGLSurfaceView.surfaceChanged(holder, format, width, height);
        }

        @CallSuper
        public void onSurfaceDestroyed(SurfaceHolder holder) {
            super.onSurfaceDestroyed(holder);
            Log.d((String)GLWallpaperService.TAG, (String)("onSurfaceDestroyed:" + (Object)((Object)this) + ", surfaceHolder=" + holder));
            this.mGLSurfaceView.surfaceDestroyed(holder);
            this.mGLSurfaceView.onDestroy();
        }

        @CallSuper
        public void onDestroy() {
            super.onDestroy();
            Log.d((String)GLWallpaperService.TAG, (String)("onDestroy:" + (Object)((Object)this)));
        }

        public void setGLWrapper(GLSurfaceView.GLWrapper glWrapper) {
            this.mGLSurfaceView.setGLWrapper(glWrapper);
        }

        public void setDebugFlags(int debugFlags) {
            this.mGLSurfaceView.setDebugFlags(debugFlags);
        }

        public int getDebugFlags() {
            return this.mGLSurfaceView.getDebugFlags();
        }

        public void setPreserveEGLContextOnPause(boolean preserveOnPause) {
            this.mGLSurfaceView.setPreserveEGLContextOnPause(preserveOnPause);
        }

        public boolean getPreserveEGLContextOnPause() {
            return this.mGLSurfaceView.getPreserveEGLContextOnPause();
        }

        public void setRenderer(GLSurfaceView.Renderer renderer) {
            this.mGLSurfaceView.setRenderer(renderer);
        }

        public void setEGLContextFactory(GLSurfaceView.EGLContextFactory factory) {
            this.mGLSurfaceView.setEGLContextFactory(factory);
        }

        public void setEGLWindowSurfaceFactory(GLSurfaceView.EGLWindowSurfaceFactory factory) {
            this.mGLSurfaceView.setEGLWindowSurfaceFactory(factory);
        }

        public void setEGLConfigChooser(GLSurfaceView.EGLConfigChooser configChooser) {
            this.mGLSurfaceView.setEGLConfigChooser(configChooser);
        }

        public void setEGLConfigChooser(boolean needDepth) {
            this.mGLSurfaceView.setEGLConfigChooser(needDepth);
        }

        public void setEGLContextClientVersion(int version) {
            this.mGLSurfaceView.setEGLContextClientVersion(version);
        }

        public void setRenderMode(int renderMode) {
            this.mGLSurfaceView.setRenderMode(renderMode);
        }

        public int getRenderMode() {
            return this.mGLSurfaceView.getRenderMode();
        }

        public void requestRender() {
            try {
                this.mGLSurfaceView.requestRender();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            this.mGLSurfaceView.surfaceCreated(holder);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            this.mGLSurfaceView.surfaceDestroyed(holder);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            this.mGLSurfaceView.surfaceChanged(holder, format, w, h);
        }

        @RequiresApi(api=26)
        public void surfaceRedrawNeededAsync(SurfaceHolder holder, Runnable finishDrawing) {
            this.mGLSurfaceView.surfaceRedrawNeededAsync(holder, finishDrawing);
        }

        public void surfaceRedrawNeeded(SurfaceHolder holder) {
            this.mGLSurfaceView.surfaceRedrawNeeded(holder);
        }

        public void onPause() {
            try {
                this.mGLSurfaceView.onPause();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void onResume() {
            try {
                this.mGLSurfaceView.onResume();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void queueEvent(Runnable r) {
            this.mGLSurfaceView.queueEvent(r);
        }
    }
}

