/*
 * Decompiled with CFR 0.152.
 */
package se.vgregion.portal.rss.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlTransformationTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlTransformationTool.class);
    static final SimpleDateFormat SWEDISH_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("sv", "SE"));
    static final SimpleDateFormat ENGLISH_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    static final List<DateTimeFormatter> OTHER_POSSIBLE_FORMATS = Arrays.asList(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mmZ"), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ"));

    private XmlTransformationTool() {
    }

    public static InputStream transformDatesToEnglish(InputStream inputStream) {
        try {
            Object object2;
            List list;
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(inputStream);
            Element element = document.getRootElement().getChild("channel");
            if (element != null) {
                list = element.getChildren("item");
                for (Object object2 : list) {
                    String string;
                    String string2;
                    Text text;
                    List list2;
                    Element element2 = (Element)object2;
                    Element element3 = element2.getChild("pubDate");
                    if (element3 != null) {
                        list2 = element3.getContent();
                        for (Object e : list2) {
                            text = (Text)e;
                            string2 = text.getText();
                            string = XmlTransformationTool.toEnglishDate(string2);
                            text.setText(string);
                        }
                        continue;
                    }
                    element3 = element2.getChild("date", Namespace.getNamespace((String)"http://purl.org/dc/elements/1.1/"));
                    if (element3 == null) continue;
                    list2 = element3.getContent();
                    for (Object e : list2) {
                        text = (Text)e;
                        string2 = text.getText();
                        string = XmlTransformationTool.toEnglishDate(string2);
                        text.setText(string);
                    }
                }
            }
            list = new XMLOutputter();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            list.output(document, byteArrayOutputStream);
            object2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return object2;
        }
        catch (IOException iOException) {
            LOGGER.error(iOException.getMessage(), (Throwable)iOException);
        }
        catch (JDOMException jDOMException) {
            LOGGER.error(jDOMException.getMessage(), (Throwable)jDOMException);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error(runtimeException.getMessage(), (Throwable)runtimeException);
        }
        return null;
    }

    static String toEnglishDate(String string) {
        try {
            Date date = SWEDISH_FORMAT.parse(string);
            String string2 = ENGLISH_FORMAT.format(date);
            return string2;
        }
        catch (ParseException parseException) {
            try {
                Date date = ENGLISH_FORMAT.parse(string);
                if (date != null) {
                    String string3 = string;
                    return string3;
                }
            }
            catch (ParseException parseException2) {
                for (DateTimeFormatter dateTimeFormatter : OTHER_POSSIBLE_FORMATS) {
                    try {
                        DateTime dateTime = dateTimeFormatter.parseDateTime(string);
                        String string4 = ENGLISH_FORMAT.format(dateTime.toDate());
                        return string4;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
                LOGGER.warn("Couldn't parse \"" + string + "\" in any format.");
                return "";
            }
            return null;
        }
    }

    static {
        SWEDISH_FORMAT.setTimeZone(TimeZone.getTimeZone("Europe/Stockholm"));
        ENGLISH_FORMAT.setTimeZone(TimeZone.getTimeZone("Europe/Stockholm"));
    }
}

