/*
 * Decompiled with CFR 0.152.
 */
package se.vgregion.portal.rss.client.chain;

import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalService;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import se.vgregion.portal.rss.client.chain.StringTemplatePlaceholderProcessor;

public class UserOrganizationProcessor
extends StringTemplatePlaceholderProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserOrganizationProcessor.class);
    private static final Locale LOCALE = new Locale("SV", "SE");
    private OrganizationLocalService organizationLocalService;
    private Map<String, String> replaceValues;
    private boolean urlValueEncoding = true;
    private static final String ENCODING = "UTF-8";

    @Autowired
    public UserOrganizationProcessor(OrganizationLocalService organizationLocalService) {
        this.organizationLocalService = organizationLocalService;
    }

    @Override
    protected Set<String> getKeys(long l) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            List list = this.organizationLocalService.getUserOrganizations(l);
            for (Organization organization : list) {
                String string = organization.getName().toLowerCase(LOCALE).replace(' ', '_');
                hashSet.add(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashSet;
    }

    @Override
    protected Map<String, String> getReplaceValues() {
        return this.replaceValues;
    }

    public void setReplaceValues(File file) throws ConfigurationException, UnsupportedEncodingException {
        try {
            LOGGER.debug("Map: {}", (Object)file.getAbsolutePath());
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
            propertiesConfiguration.setEncoding(ENCODING);
            propertiesConfiguration.load(file);
            this.replaceValues = new HashMap<String, String>();
            Iterator iterator = propertiesConfiguration.getKeys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = propertiesConfiguration.getString(string);
                LOGGER.debug("Key: {} Value: {}", new Object[]{string, string2});
                if (StringUtils.isBlank((String)string2)) continue;
                string2 = this.urlValueEncoding ? URLEncoder.encode(string2, ENCODING) : string2;
                string = string.toLowerCase(LOCALE);
                this.replaceValues.put(string, string2);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = "Encoding failure in mapping";
            LOGGER.error(string + " file [" + this.mapFilePathErrorMessage(file) + "]", (Throwable)unsupportedEncodingException);
        }
        catch (ConfigurationException configurationException) {
            String string = "Failed to load replaceValues mapping";
            LOGGER.error(string + " file [" + this.mapFilePathErrorMessage(file) + "]", (Throwable)configurationException);
        }
    }

    private String mapFilePathErrorMessage(File file) {
        if (file == null) {
            return "No mapFile has been configured";
        }
        return file.getAbsolutePath();
    }

    public void setUrlValueEncoding(Boolean bl) {
        this.urlValueEncoding = bl;
    }
}

