/*
 * Decompiled with CFR 0.152.
 */
package se.solrike.sonarlint.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ProviderFactory;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleDetails;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import se.solrike.sonarlint.Sonarlint;
import se.solrike.sonarlint.impl.IssueEx;
import se.solrike.sonarlint.impl.util.SarifJsonBuilder;
import se.solrike.sonarlint.impl.util.SpotbugsXmlBuilder;

public class ReportAction {
    protected final Sonarlint mTask;
    protected final Logger mLogger;
    protected final ProjectLayout mLayout;
    protected final ProviderFactory mProviderFactory;
    protected Map<String, Render> mReportRenders;
    private static final Map<RuleType, String> sIssueTypeIcon = Map.ofEntries(Map.entry(RuleType.BUG, "\ud83d\ude31 Bug  "), Map.entry(RuleType.CODE_SMELL, "\ud83e\udd22 Smell"), Map.entry(RuleType.VULNERABILITY, "\ud83d\ude08 Sec. "), Map.entry(RuleType.SECURITY_HOTSPOT, "Review "));
    private static final Map<IssueSeverity, String> sIssueSeverityIcon = Map.ofEntries(Map.entry(IssueSeverity.BLOCKER, "\ud83c\udf2a  Block"), Map.entry(IssueSeverity.CRITICAL, "\ud83c\udf29  Crit."), Map.entry(IssueSeverity.MAJOR, "\ud83c\udf28  Major"), Map.entry(IssueSeverity.MINOR, "\ud83c\udf26  Minor"), Map.entry(IssueSeverity.INFO, "\ud83c\udf24  Info "));

    public ReportAction(Sonarlint task, Logger logger, ProjectLayout layout, ProviderFactory providerFactory) {
        this.mLogger = logger;
        this.mLayout = layout;
        this.mProviderFactory = providerFactory;
        this.mTask = task;
        this.mReportRenders = Map.ofEntries(Map.entry("text", this::renderTextReport), Map.entry("html", this::renderHtmlReport), Map.entry("xml", this::renderXmlReport), Map.entry("sarif", this::renderSarifReport));
    }

    public void report(List<IssueEx> issues) {
        SortedMap reports = this.mTask.getReports().getAsMap();
        reports.forEach((name, report) -> {
            if (((Boolean)report.getEnabled().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
                RegularFile file = (RegularFile)report.getOutputLocation().getOrElse((Object)this.getDefaultReportOutputLocation((String)name));
                File parentDir = file.getAsFile().getParentFile();
                parentDir.mkdirs();
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file.getAsFile(), Charset.forName("UTF-8")));){
                    this.mReportRenders.get(name).render(writer, issues);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.mLogger.error("Report generated at: {}", (Object)file);
            }
        });
    }

    protected void renderTextReport(Writer writer, Iterable<IssueEx> issues) throws IOException {
        for (IssueEx issue : issues) {
            writer.write(String.format("%n%s %s %s %s at: %s:%d:%d%n%n", this.getIssueTypeIcon(issue.getType()), this.getIssueSeverityIcon(issue.getSeverity()), issue.getRuleKey(), issue.getMessage(), issue.getInputFileRelativePath(), issue.getStartLine(), issue.getStartLineOffset()));
        }
    }

    protected void renderHtmlReport(Writer writer, Collection<IssueEx> issues) throws IOException {
        writer.write(this.getHtmlHeader());
        writer.write("<h1>Summary</h1>\n");
        writer.write("<list>\n");
        Map<RuleType, Long> issueCountPerType = issues.stream().collect(Collectors.groupingBy(IssueEx::getType, Collectors.counting()));
        for (Map.Entry<RuleType, Long> issueType : issueCountPerType.entrySet()) {
            writer.write(String.format("<li>%s: %d</li>%n", this.getIssueTypeIcon(issueType.getKey()), issueType.getValue()));
        }
        writer.write("</list>\n");
        writer.write("<h1>TOC</h1>\n<list>\n");
        for (IssueEx issue : issues) {
            writer.write(String.format("<li>%s %s, <a href=\"#%d\">%s (%s)</a> at %s</li>%n", this.getIssueTypeIcon(issue.getType()), this.getIssueSeverityIcon(issue.getSeverity()), issue.getId(), StringEscapeUtils.escapeHtml4((String)issue.getMessage()), issue.getRuleKey(), issue.getFileName()));
        }
        writer.write("</list>\n");
        for (IssueEx issue : issues) {
            writer.write(String.format("<h1 id=\"%d\">%s (%s)</h1>%n", issue.getId(), StringEscapeUtils.escapeHtml4((String)issue.getMessage()), issue.getRuleKey()));
            writer.write(String.format("<p>%s %s</p>%n", this.getIssueTypeIcon(issue.getType()), this.getIssueSeverityIcon(issue.getSeverity())));
            writer.write(String.format("<p>%s:%d:%d</p>%n", issue.getInputFileRelativePath(), issue.getStartLine(), issue.getStartLineOffset()));
            Optional<StandaloneRuleDetails> rulesDetails = issue.getRulesDetails();
            if (!rulesDetails.isPresent()) continue;
            writer.write(rulesDetails.get().getHtmlDescription());
            writer.write("\n");
            writer.write("\n");
        }
        writer.write("</body>\n</html>");
    }

    protected String getHtmlHeader() {
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html lang=\"en\">\n<head>\n  <meta charset=\"UTF-8\">\n  <title>SonarLint analysis report</title>\n  <style type=\"text/css\">\n    h1 {\n      background-color: LightGray;\n    }\n  </style>\n</head>\n<body>\n";
    }

    protected void renderXmlReport(Writer writer, Collection<IssueEx> issues) {
        new SpotbugsXmlBuilder().generateBugCollection(writer, issues, Set.of(this.mLayout.getProjectDirectory().getAsFile()));
    }

    protected void renderSarifReport(Writer writer, Collection<IssueEx> issues) {
        new SarifJsonBuilder().generateBugCollection(writer, issues, this.mLayout.getProjectDirectory().getAsFile());
    }

    public String getIssueTypeIcon(RuleType ruleType) {
        return sIssueTypeIcon.get(ruleType);
    }

    public String getIssueSeverityIcon(IssueSeverity issueSeverity) {
        return sIssueSeverityIcon.get(issueSeverity);
    }

    protected RegularFile getDefaultReportOutputLocation(String reportName) {
        File file = new File(((Directory)this.mTask.getReportsDir().get()).getAsFile(), this.mTask.getName() + "." + reportName);
        String filePath = file.getAbsolutePath();
        return this.mLayout.getProjectDirectory().file(filePath);
    }

    @FunctionalInterface
    public static interface Render {
        public void render(Writer var1, List<IssueEx> var2) throws IOException;
    }
}

