/*
 * Decompiled with CFR 0.152.
 */
package se.solrike.sonarlint.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.api.Flow;
import org.sonarsource.sonarlint.core.analysis.api.QuickFix;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleDetails;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.commons.TextRange;
import org.sonarsource.sonarlint.core.commons.VulnerabilityProbability;

public class IssueEx
implements Issue {
    private Issue mSonarlintIssue;
    private Optional<StandaloneRuleDetails> mRulesDetails;
    private final int mId;

    public IssueEx(int id, Issue sonarlintIssue) {
        this.mId = id;
        this.mSonarlintIssue = sonarlintIssue;
    }

    public int getId() {
        return this.mId;
    }

    public TextRange getTextRange() {
        return this.mSonarlintIssue.getTextRange();
    }

    public String getMessage() {
        return this.mSonarlintIssue.getMessage();
    }

    public ClientInputFile getInputFile() {
        return this.mSonarlintIssue.getInputFile();
    }

    public String getInputFileRelativePath() {
        ClientInputFile inputFile = this.mSonarlintIssue.getInputFile();
        if (inputFile != null) {
            return inputFile.relativePath();
        }
        return "global";
    }

    public Integer getStartLine() {
        return this.mSonarlintIssue.getStartLine();
    }

    public IssueSeverity getSeverity() {
        return this.mSonarlintIssue.getSeverity();
    }

    public RuleType getType() {
        return this.mSonarlintIssue.getType();
    }

    public String getRuleKey() {
        return this.mSonarlintIssue.getRuleKey();
    }

    public Integer getStartLineOffset() {
        return this.mSonarlintIssue.getStartLineOffset();
    }

    public List<Flow> flows() {
        return this.mSonarlintIssue.flows();
    }

    public List<QuickFix> quickFixes() {
        return this.mSonarlintIssue.quickFixes();
    }

    public Integer getEndLine() {
        return this.mSonarlintIssue.getEndLine();
    }

    public Integer getEndLineOffset() {
        return this.mSonarlintIssue.getEndLineOffset();
    }

    public Optional<StandaloneRuleDetails> getRulesDetails() {
        return this.mRulesDetails;
    }

    public void setRulesDetails(Optional<StandaloneRuleDetails> rulesDetails) {
        this.mRulesDetails = rulesDetails;
    }

    public String getFileName() {
        ClientInputFile inputFile = this.mSonarlintIssue.getInputFile();
        if (inputFile != null) {
            String path = inputFile.relativePath();
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return "global";
    }

    public Optional<CleanCodeAttribute> getCleanCodeAttribute() {
        return this.mSonarlintIssue.getCleanCodeAttribute();
    }

    public Map<SoftwareQuality, ImpactSeverity> getImpacts() {
        return this.mSonarlintIssue.getImpacts();
    }

    public Optional<String> getRuleDescriptionContextKey() {
        return this.mSonarlintIssue.getRuleDescriptionContextKey();
    }

    public Optional<VulnerabilityProbability> getVulnerabilityProbability() {
        return this.mSonarlintIssue.getVulnerabilityProbability();
    }
}

