/*
 * Decompiled with CFR 0.152.
 */
package se.solrike.sonarlint.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;

public class ClientInputFileImpl
implements ClientInputFile {
    private final Path mPath;
    private final boolean mTest;
    private final Charset mCharset;
    private final Path mBaseDir;

    public ClientInputFileImpl(Path baseDir, Path path, boolean test, Charset charset) {
        this.mBaseDir = baseDir;
        this.mPath = path;
        this.mTest = test;
        this.mCharset = charset;
    }

    @Deprecated
    public String getPath() {
        return this.mPath.toString();
    }

    public boolean isTest() {
        return this.mTest;
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    public <G> G getClientObject() {
        return null;
    }

    public InputStream inputStream() throws IOException {
        return Files.newInputStream(this.mPath, new OpenOption[0]);
    }

    public String contents() throws IOException {
        return new String(Files.readAllBytes(this.mPath), this.mCharset);
    }

    public String relativePath() {
        return this.mBaseDir.relativize(this.mPath).toString();
    }

    public URI uri() {
        return this.mPath.toUri();
    }

    public String toString() {
        return this.relativePath();
    }
}

