/*
 * Decompiled with CFR 0.152.
 */
package se.solrike.sonarlint;

import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.solrike.sonarlint.Sonarlint;
import se.solrike.sonarlint.SonarlintExtension;

public class SonarlintPlugin
implements Plugin<Project> {
    private static final Logger sLogger = LoggerFactory.getLogger(SonarlintPlugin.class);
    private static final GradleVersion SUPPORTED_VERSION = GradleVersion.version((String)"7.5");
    public static final String CONFIG_NAME = "sonarlint";
    public static final String PLUGINS_CONFIG_NAME = "sonarlintPlugins";
    public static final String EXTENSION_NAME = "sonarlint";
    public static final String TASK_NAME = "sonarlint";
    public static final String REPORTS_SUBDIR = "sonarlint";

    public void apply(Project project) {
        this.verifyGradleVersion(GradleVersion.current());
        project.getPluginManager().apply(ReportingBasePlugin.class);
        DirectoryProperty reportsBaseDir = ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory();
        SonarlintExtension extension = this.createExtension(project, reportsBaseDir);
        this.createConfiguration(project);
        this.createPluginConfiguration(project);
        this.createTasks(project, extension);
    }

    private void createConfiguration(Project project) {
        ((Configuration)project.getConfigurations().create("sonarlint")).setDescription("configuration for the Sonarlint plugin").setVisible(false).setTransitive(true);
    }

    private Configuration createPluginConfiguration(Project project) {
        return ((Configuration)project.getConfigurations().create(PLUGINS_CONFIG_NAME)).setDescription("configuration for the external SonarLint plugins").setVisible(false).setTransitive(false);
    }

    protected SonarlintExtension createExtension(Project project, DirectoryProperty reportsBaseDir) {
        SonarlintExtension extension = (SonarlintExtension)project.getExtensions().create("sonarlint", SonarlintExtension.class, new Object[0]);
        extension.getIgnoreFailures().set((Object)Boolean.FALSE);
        extension.getMaxIssues().set((Object)0);
        extension.getShowIssues().set((Object)Boolean.TRUE);
        DirectoryProperty sonarlintReportsDirectory = project.getObjects().directoryProperty().convention(reportsBaseDir.map(d -> d.dir("sonarlint")));
        extension.getReportsDir().set((Provider)sonarlintReportsDirectory);
        return extension;
    }

    protected void configureTaskForJavaSourceSet(SourceSet sourceSet, Sonarlint task) {
        task.setSource((FileTree)sourceSet.getAllSource());
        task.setCompileClasspath(sourceSet.getCompileClasspath());
        task.setClassFiles((FileCollection)sourceSet.getOutput());
        task.getIsTestSource().set((Object)sourceSet.getName().contains("test"));
    }

    protected void createTasks(Project project, SonarlintExtension extension) {
        project.getPlugins().withType(JavaBasePlugin.class).configureEach(javaBasePlugin -> this.getJavaSourceSetContainer(project).all(sourceSet -> {
            String name = sourceSet.getTaskName("sonarlint", null);
            sLogger.debug("Creating sonarlint task for {}", sourceSet);
            TaskProvider<Sonarlint> taskProvider = this.createTask(project, extension, name);
            String description = String.format("Run SonarLint analysis for the source set '%s'", sourceSet.getName());
            ((Sonarlint)((Object)((Object)((Object)taskProvider.get())))).setDescription(description);
            ((Sonarlint)((Object)((Object)((Object)taskProvider.get())))).dependsOn(new Object[]{sourceSet.getClassesTaskName()});
            this.configureTaskForJavaSourceSet((SourceSet)sourceSet, (Sonarlint)((Object)((Object)((Object)taskProvider.get()))));
        }));
        if (project.getPluginManager().hasPlugin("com.github.node-gradle.node")) {
            List<String> taskNames = List.of("Main", "Test");
            for (String taskName : taskNames) {
                TaskProvider<Sonarlint> taskProvider = this.createTask(project, extension, "sonarlintNode" + taskName);
                String description = String.format("Run SonarLint analysis for node %s classes", taskName.toLowerCase());
                ((Sonarlint)((Object)taskProvider.get())).setDescription(description);
            }
        }
    }

    protected TaskProvider<Sonarlint> createTask(Project project, SonarlintExtension extension, String taskName) {
        TaskProvider taskProvider = project.getTasks().register(taskName, Sonarlint.class, task -> {
            task.setGroup("verification");
            task.getExcludeRules().set(extension.getExcludeRules());
            task.getIncludeRules().set(extension.getIncludeRules());
            task.getMaxIssues().set(extension.getMaxIssues());
            task.getMinSeverity().set(extension.getMinSeverity());
            task.getIgnoreFailures().set(extension.getIgnoreFailures());
            task.getRuleParameters().set(extension.getRuleParameters());
            task.getShowIssues().set(extension.getShowIssues());
            task.getReportsDir().set((Provider)extension.getReportsDir());
            extension.getReports().whenObjectAdded(report -> task.getReports().add(report));
        });
        project.getTasks().named("check").configure(t -> t.dependsOn(new Object[]{taskProvider}));
        return taskProvider;
    }

    private SourceSetContainer getJavaSourceSetContainer(Project project) {
        return ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
    }

    protected void verifyGradleVersion(GradleVersion version) {
        if (version.compareTo(SUPPORTED_VERSION) < 0) {
            String message = String.format("Gradle version %s is unsupported. Please use %s or later.", version, SUPPORTED_VERSION);
            throw new IllegalArgumentException(message);
        }
    }
}

