/*
 * Decompiled with CFR 0.152.
 */
package se.solrike.sonarlint.impl;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.SetProperty;
import org.sonarsource.sonarlint.core.StandaloneSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleKey;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;
import org.sonarsource.sonarlint.core.commons.progress.ClientProgressMonitor;
import org.sonarsource.sonarlint.core.plugin.commons.SkipReason;
import se.solrike.sonarlint.Sonarlint;
import se.solrike.sonarlint.impl.ClientInputFileImpl;
import se.solrike.sonarlint.impl.GradleClientLogOutput;
import se.solrike.sonarlint.impl.GradleProgressMonitor;
import se.solrike.sonarlint.impl.IssueCollector;
import se.solrike.sonarlint.impl.IssueEx;
import se.solrike.sonarlint.impl.util.NodePluginUtil;

public class SonarlintAction {
    private Path mNodeExec;
    private String mNodeVersion;

    public SonarlintAction(Sonarlint task) {
        NodePluginUtil nodeUtil;
        Project project = task.getProject();
        if (project.getExtensions().findByName("node") != null && (nodeUtil = new NodePluginUtil()).getDownload(project)) {
            this.mNodeExec = nodeUtil.getNodeExec(project);
            this.mNodeVersion = nodeUtil.getNodeVersion(project);
        }
    }

    public List<IssueEx> run(Sonarlint task, SetProperty<File> plugins, ProjectLayout layout) {
        return this.analyze(task, task.getLogger(), plugins, layout);
    }

    protected List<IssueEx> analyze(Sonarlint task, Logger logger, SetProperty<File> plugins, ProjectLayout layout) {
        HashMap<String, String> sonarProperties = new HashMap<String, String>();
        Project project = task.getProject();
        if (project.getProperties().containsKey("sourceCompatibility")) {
            String sourceCompatibility = project.getProperties().get("sourceCompatibility").toString();
            sonarProperties.put("sonar.java.source", sourceCompatibility);
        }
        Set compileClasspath = Collections.emptySet();
        if (task.getCompileClasspath() != null) {
            compileClasspath = task.getCompileClasspath().getFiles();
        }
        Set classFiles = Collections.emptySet();
        if (task.getClassFiles() != null) {
            classFiles = task.getClassFiles().getFiles();
        }
        String libs = compileClasspath.stream().filter(File::exists).map(File::getPath).collect(Collectors.joining(","));
        sonarProperties.put("sonar.java.libraries", libs);
        String binaries = classFiles.stream().filter(File::exists).map(File::getPath).collect(Collectors.joining(","));
        sonarProperties.put("sonar.java.binaries", binaries);
        boolean isTestSource = (Boolean)task.getIsTestSource().getOrElse((Object)Boolean.FALSE);
        if (isTestSource) {
            sonarProperties.put("sonar.java.test.libraries", libs);
            sonarProperties.put("sonar.java.test.binaries", binaries);
        }
        Set sourceFiles = task.getSource().getFiles();
        Set excludeRules = (Set)task.getExcludeRules().get();
        Set includeRules = (Set)task.getIncludeRules().get();
        Map ruleParameters = (Map)task.getRuleParameters().get();
        Path[] pluginPaths = (Path[])((Set)plugins.get()).stream().map(File::toPath).toArray(Path[]::new);
        Path projectDir = layout.getProjectDirectory().getAsFile().toPath();
        StandaloneGlobalConfiguration.Builder builder = (StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)StandaloneGlobalConfiguration.builder().addEnabledLanguages(Language.values())).addPlugins(pluginPaths).setLogOutput((ClientLogOutput)new GradleClientLogOutput(logger))).setWorkDir(((File)layout.getBuildDirectory().getAsFile().get()).toPath().resolve("sonarlint"))).setSonarLintUserHome(projectDir);
        if (this.mNodeExec != null && this.mNodeVersion != null) {
            builder.setNodeJs(this.mNodeExec, Version.create((String)this.mNodeVersion));
        }
        List fileList = sourceFiles.stream().map(f -> new ClientInputFileImpl(projectDir, f.toPath(), isTestSource, StandardCharsets.UTF_8)).collect(Collectors.toList());
        StandaloneAnalysisConfiguration analysisConfiguration = ((StandaloneAnalysisConfiguration.Builder)((StandaloneAnalysisConfiguration.Builder)((StandaloneAnalysisConfiguration.Builder)StandaloneAnalysisConfiguration.builder().setBaseDir(projectDir)).addInputFiles(fileList)).addExcludedRules(this.getRuleKeys(excludeRules)).addIncludedRules(this.getRuleKeys(includeRules)).addRuleParameters(this.getRuleParameters(ruleParameters)).putAllExtraProperties(sonarProperties)).build();
        StandaloneGlobalConfiguration globalConfiguration = builder.build();
        StandaloneSonarLintEngineImpl engine = new StandaloneSonarLintEngineImpl(globalConfiguration);
        Collection pluginDetails = engine.getPluginDetails();
        pluginDetails.forEach(details -> {
            if (details.skipReason().isPresent()) {
                String errorMessage = "Failed to load plugin '" + details.name() + "' version " + details.version() + ". ";
                errorMessage = ((SkipReason)details.skipReason().get()).equals(SkipReason.IncompatiblePluginApi.INSTANCE) ? errorMessage + "Plugin version too new for Sonarlint." : errorMessage + ((SkipReason)details.skipReason().get()).toString();
                throw new GradleException(errorMessage);
            }
        });
        IssueCollector collector = new IssueCollector();
        AnalysisResults results = engine.analyze(analysisConfiguration, (IssueListener)collector, (ClientLogOutput)new GradleClientLogOutput(logger), (ClientProgressMonitor)new GradleProgressMonitor(logger));
        List<IssueEx> issues = collector.getIssues();
        issues.forEach(arg_0 -> SonarlintAction.lambda$analyze$3((StandaloneSonarLintEngine)engine, arg_0));
        logger.debug("Files: {}", (Object)results.indexedFileCount());
        logger.debug("Issues: {}", issues);
        try {
            engine.stop();
        }
        catch (Exception e) {
            logger.warn("could not stop the engine");
        }
        return issues;
    }

    protected RuleKey[] getRuleKeys(Set<String> rules) {
        return (RuleKey[])rules.stream().map(RuleKey::parse).toArray(RuleKey[]::new);
    }

    protected Map<RuleKey, Map<String, String>> getRuleParameters(Map<String, Map<String, String>> ruleParameters) {
        return ruleParameters.entrySet().stream().collect(Collectors.toMap(rp -> RuleKey.parse((String)((String)rp.getKey())), Map.Entry::getValue));
    }

    private static /* synthetic */ void lambda$analyze$3(StandaloneSonarLintEngine engine, IssueEx i) {
        i.setRulesDetails(engine.getRuleDetails(i.getRuleKey()));
    }
}

