/*
 * Decompiled with CFR 0.152.
 */
package se.solrike.sonarlint;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;
import org.sonarsource.sonarlint.core.StandaloneSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleDetails;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleParam;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;
import se.solrike.sonarlint.SonarlintExtension;
import se.solrike.sonarlint.impl.GradleClientLogOutput;
import se.solrike.sonarlint.impl.util.NodePluginUtil;

public class SonarlintListRules
extends DefaultTask {
    protected Set<String> mIncludedRules;
    protected Set<String> mExcludedRules;
    protected Map<String, Map<String, String>> mRuleParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void run() {
        Logger logger = this.getLogger();
        if (this.getProject().getExtensions().findByType(SonarlintExtension.class) != null) {
            SonarlintExtension extension = (SonarlintExtension)this.getProject().getExtensions().findByType(SonarlintExtension.class);
            this.mIncludedRules = (Set)extension.getIncludeRules().getOrNull();
            this.mExcludedRules = (Set)extension.getExcludeRules().getOrNull();
            this.mRuleParameters = (Map)extension.getRuleParameters().getOrNull();
        }
        Configuration pluginConfiguration = this.getProject().getConfigurations().getByName("sonarlintPlugins");
        Path[] plugins = (Path[])pluginConfiguration.getFiles().stream().map(File::toPath).toArray(Path[]::new);
        StandaloneGlobalConfiguration.Builder builder = (StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)StandaloneGlobalConfiguration.builder().addEnabledLanguages(Language.values())).addPlugins(plugins).setLogOutput((ClientLogOutput)new GradleClientLogOutput(logger))).setWorkDir(this.getProject().getBuildDir().toPath().resolve("sonarlint"))).setSonarLintUserHome(this.getProject().getProjectDir().toPath());
        if (this.getProject().getExtensions().findByName("node") != null) {
            NodePluginUtil nodeUtil = new NodePluginUtil();
            if (nodeUtil.getDownload(this.getProject())) {
                Path nodeExec = nodeUtil.getNodeExec(this.getProject());
                logger.debug("node exec: {}", (Object)nodeExec);
                builder.setNodeJs(nodeExec, Version.create((String)nodeUtil.getNodeVersion(this.getProject())));
            } else {
                logger.error("Node plugin 'com.github.node-gradle.node' is not configured with download=true. Sonarlint analysis will not be performed on JavaScript/TypeScript source code");
            }
        }
        StandaloneGlobalConfiguration globalConfiguration = builder.build();
        StandaloneSonarLintEngineImpl engine = new StandaloneSonarLintEngineImpl(globalConfiguration);
        try {
            ArrayList rules = new ArrayList(engine.getAllRuleDetails());
            rules.sort(this::compare);
            rules.forEach(this::printRule);
        }
        finally {
            engine.stop();
        }
    }

    int compare(StandaloneRuleDetails rule1, StandaloneRuleDetails rule2) {
        String key1 = rule1.getKey();
        String key2 = rule2.getKey();
        if (rule1.getLanguage().equals((Object)rule2.getLanguage()) && this.keyHasId(key1) && this.keyHasId(key2)) {
            return this.getKeyId(key1) - this.getKeyId(key2);
        }
        return key1.compareTo(key2);
    }

    boolean keyHasId(String key) {
        return key.matches(".*:S\\d+");
    }

    int getKeyId(String key) {
        String id = key.substring(key.indexOf(":S") + 2);
        return Integer.parseInt(id);
    }

    void printRule(StandaloneRuleDetails rule) {
        Logger logger = this.getLogger();
        logger.warn("[{}] {} - {} - {} - {}", new Object[]{this.isActive(rule) ? "x" : " ", rule.getKey(), rule.getName(), rule.getTags(), rule.getLanguage()});
        rule.paramDetails().forEach(param -> logger.warn("    {} : {}", (Object)param.key(), (Object)this.getParamValue(rule.getKey(), (StandaloneRuleParam)param)));
    }

    boolean isActive(StandaloneRuleDetails rule) {
        boolean isActive = rule.isActiveByDefault();
        if (isActive && this.mExcludedRules != null) {
            isActive = !this.mExcludedRules.contains(rule.getKey());
        } else if (!isActive && this.mIncludedRules != null) {
            isActive = this.mIncludedRules.contains(rule.getKey());
        }
        return isActive;
    }

    String getParamValue(String ruleKey, StandaloneRuleParam defaultParam) {
        Map<String, String> overrideParams = this.mRuleParameters.getOrDefault(ruleKey, Map.of("", ""));
        return overrideParams.getOrDefault(defaultParam.key(), defaultParam.defaultValue());
    }
}

