/*
 * Decompiled with CFR 0.152.
 */
package se.solrike.sonarlint;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import se.solrike.sonarlint.SonarlintReport;
import se.solrike.sonarlint.impl.IssueEx;
import se.solrike.sonarlint.impl.ReportAction;
import se.solrike.sonarlint.impl.SonarlintAction;

public abstract class Sonarlint
extends SourceTask {
    private FileCollection mCompileClasspath;
    private FileCollection mClassFiles;
    private final SonarlintAction mAction = new SonarlintAction(this);

    @Input
    public abstract SetProperty<String> getExcludeRules();

    @Input
    public abstract SetProperty<String> getIncludeRules();

    @Input
    @Optional
    public abstract Property<Boolean> getIgnoreFailures();

    @Input
    @Optional
    public abstract Property<Boolean> getIsTestSource();

    @Input
    @Optional
    public abstract Property<Integer> getMaxIssues();

    @Input
    @Optional
    public abstract Property<Boolean> getShowIssues();

    @Internal
    public abstract NamedDomainObjectContainer<SonarlintReport> getReports();

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getReportsDir();

    @Input
    public abstract MapProperty<String, Map<String, String>> getRuleParameters();

    @CompileClasspath
    @Optional
    public FileCollection getCompileClasspath() {
        return this.mCompileClasspath;
    }

    public void setCompileClasspath(FileCollection fileCollection) {
        this.mCompileClasspath = fileCollection;
    }

    @Classpath
    @Optional
    public FileCollection getClassFiles() {
        return this.mClassFiles;
    }

    public void setClassFiles(FileCollection sourceSetOutput) {
        this.mClassFiles = sourceSetOutput;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ProviderFactory getProjectProvider();

    @Internal
    protected abstract SetProperty<File> getSonarlintConfiguration();

    public Sonarlint() {
        Provider artifactProvider = this.getProject().getConfigurations().named("sonarlintPlugins").flatMap(c -> c.getIncoming().getArtifacts().getResolvedArtifacts());
        this.getSonarlintConfiguration().set(artifactProvider.map(p -> p.stream().map(ResolvedArtifactResult::getFile).collect(Collectors.toSet())));
    }

    @TaskAction
    public void run() {
        boolean ignoreFailures;
        Logger logger = this.getLogger();
        this.logTaskParameters();
        List<IssueEx> issues = this.mAction.run(this, this.getSonarlintConfiguration(), this.getProjectLayout());
        String resultMessage = String.format("%d SonarLint issue(s) were found. Max issue(s) allowed: %d.", issues.size(), this.getMaxIssues().getOrElse((Object)0));
        logger.error(resultMessage);
        ReportAction reportAction = new ReportAction(this, logger, this.getProjectLayout(), this.getProjectProvider());
        reportAction.report(issues);
        if (Boolean.TRUE.equals(this.getShowIssues().getOrElse((Object)Boolean.TRUE)) && logger.isErrorEnabled()) {
            for (IssueEx issue : issues) {
                logger.error("\n{} {} {} {} at: {}:{}:{}", new Object[]{reportAction.getIssueTypeIcon(issue.getType()), reportAction.getIssueSeverityIcon(issue.getSeverity()), issue.getRuleKey(), issue.getMessage(), issue.getInputFileRelativePath(), issue.getStartLine(), issue.getStartLineOffset()});
            }
        }
        if (!(ignoreFailures = ((Boolean)this.getIgnoreFailures().getOrElse((Object)Boolean.FALSE)).booleanValue()) && issues.size() > (Integer)this.getMaxIssues().getOrElse((Object)0)) {
            throw new GradleException(resultMessage);
        }
    }

    private void logTaskParameters() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(">>> SonarLint task " + this.getName());
            this.getLogger().debug("SonarLint reports " + this.getReports().getAsMap());
            this.getLogger().debug("Exclude rules: " + this.getExcludeRules().getOrNull());
            this.getLogger().debug("Include rules: " + this.getIncludeRules().getOrNull());
            this.getLogger().debug("RuleParams: " + this.getRuleParameters().getOrNull());
            this.getLogger().debug("Source: {}", (Object)this.getSource().getAsPath());
            this.getLogger().debug("Source files: {}", (Object)this.getSource().getAsFileTree().getFiles());
            this.getLogger().debug("IsTestSource: {}", this.getIsTestSource().getOrElse((Object)Boolean.FALSE));
            String sonarlintPlugins = ((Set)this.getSonarlintConfiguration().get()).stream().map(File::getName).reduce("", (p1, p2) -> p1 + ", " + p2);
            this.getLogger().debug("Plugins: {}", (Object)sonarlintPlugins);
            this.getLogger().debug("<<< SonarLint task " + this.getName());
        }
    }
}

