/*
 * Decompiled with CFR 0.152.
 */
package se.patrikerdes;

import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import se.patrikerdes.Common;
import se.patrikerdes.DependencyUpdate;

public class UseLatestVersionsCheckTask
extends DefaultTask
implements GroovyObject {
    @Input
    @Option(description="The same argument that was passed to useLatestVersions", option="update-dependency")
    private List<String> updateWhitelist;
    @Input
    @Option(description="A blacklist of dependencies to update, in the format of group:name", option="ignore-dependency")
    private List<String> updateBlacklist;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public UseLatestVersionsCheckTask() {
        MetaClass metaClass;
        List list = Collections.emptyList();
        this.updateWhitelist = list;
        List list2 = Collections.emptyList();
        this.updateBlacklist = list2;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string = "Check if all available updates were successfully applied by the useLatestVersions task.";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, UseLatestVersionsCheckTask.class, (GroovyObject)this, (String)"description");
        String string2 = "Help";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, UseLatestVersionsCheckTask.class, (GroovyObject)this, (String)"group");
    }

    @TaskAction
    public void useLatestVersionsCheckTask() {
        this.validateExclusiveWhiteOrBlacklist();
        File previousDependencyUpdatesReport = new File(new File(((ProjectInternal)this.getProject()).getBuildDir(), "useLatestVersions"), "latestDependencyUpdatesReport.json");
        File currentDependencyUpdatesReport = new File(Common.getDependencyUpdatesJsonReportFilePath(this.getProject()));
        if (!previousDependencyUpdatesReport.exists()) {
            throw (Throwable)new GradleException("No results from useLatestVersions were found, aborting");
        }
        Object previousDependencyUpdatesJson = new JsonSlurper().parse(previousDependencyUpdatesReport);
        Object currentDependencyUpdatesJson = new JsonSlurper().parse(currentDependencyUpdatesReport);
        List<DependencyUpdate> wasUpdateable = Common.getOutDatedDependencies(previousDependencyUpdatesJson);
        List<DependencyUpdate> leftToUpdate = Common.getOutDatedDependencies(currentDependencyUpdatesJson);
        int skippedCount = this.getSkippedCount(leftToUpdate);
        int failedCount = leftToUpdate.size() - skippedCount;
        if (failedCount > 0) {
            DefaultGroovyMethods.println((Object)((Object)this), (Object)new GStringImpl(new Object[]{failedCount, UseLatestVersionsCheckTask.deps(failedCount)}, new String[]{"useLatestVersions failed to update ", " ", " "}).plus("to the latest version:"));
            DependencyUpdate dependencyUpdate2 = null;
            for (DependencyUpdate dependencyUpdate2 : leftToUpdate) {
                if (!(skippedCount == 0 || this.updateWhitelist.contains(dependencyUpdate2.groupAndName()))) continue;
                DefaultGroovyMethods.println((Object)((Object)this), (Object)StringGroovyMethods.plus((CharSequence)" - ", (Object)dependencyUpdate2));
            }
        }
        int updatedCount = wasUpdateable.size() - leftToUpdate.size();
        if (updatedCount < 0) {
            int n;
            updatedCount = n = 0;
        }
        if (updatedCount > 0) {
            DefaultGroovyMethods.println((Object)((Object)this), (Object)new GStringImpl(new Object[]{updatedCount, UseLatestVersionsCheckTask.deps(updatedCount)}, new String[]{"useLatestVersions successfully updated ", " ", " "}).plus("to the latest version:"));
            DependencyUpdate dependencyWasUpdateable2 = null;
            for (DependencyUpdate dependencyWasUpdateable2 : wasUpdateable) {
                boolean wasUpdated = true;
                DependencyUpdate dependencyLeftToUpdate2 = null;
                for (DependencyUpdate dependencyLeftToUpdate2 : leftToUpdate) {
                    boolean bl;
                    if (!ScriptBytecodeAdapter.compareEqual((Object)dependencyWasUpdateable2.groupAndName(), (Object)dependencyLeftToUpdate2.groupAndName())) continue;
                    wasUpdated = bl = false;
                }
                if (!wasUpdated) continue;
                DefaultGroovyMethods.println((Object)((Object)this), (Object)StringGroovyMethods.plus((CharSequence)" - ", (Object)dependencyWasUpdateable2));
            }
        }
        if (skippedCount > 0) {
            this.printSkippedDependenciesMessage(skippedCount, leftToUpdate);
        }
        if (updatedCount == 0 && failedCount == 0) {
            DefaultGroovyMethods.println((Object)((Object)this), (Object)"useLatestVersions successfully did nothing; there was nothing to update");
        }
        if (failedCount > 0) {
            throw (Throwable)new GradleException("useLatestVersions failed");
        }
    }

    private void printSkippedDependenciesMessage(int skippedCount, List<DependencyUpdate> leftToUpdate) {
        if (!this.updateWhitelist.isEmpty()) {
            DefaultGroovyMethods.println((Object)((Object)this), (Object)new GStringImpl(new Object[]{skippedCount, UseLatestVersionsCheckTask.deps(skippedCount)}, new String[]{"useLatestVersions skipped updating ", " ", " "}).plus("not in --update-dependency:"));
            DependencyUpdate dependencyLeftToUpdate2 = null;
            for (DependencyUpdate dependencyLeftToUpdate2 : leftToUpdate) {
                if (!(!this.updateWhitelist.contains(DefaultTypeTransformation.booleanUnbox((Object)dependencyLeftToUpdate2.groupAndName()) && !this.updateWhitelist.contains(dependencyLeftToUpdate2.getGroup())))) continue;
                DefaultGroovyMethods.println((Object)((Object)this), (Object)StringGroovyMethods.plus((CharSequence)" - ", (Object)dependencyLeftToUpdate2));
            }
        }
        if (!this.updateBlacklist.isEmpty()) {
            DefaultGroovyMethods.println((Object)((Object)this), (Object)new GStringImpl(new Object[]{skippedCount, UseLatestVersionsCheckTask.deps(skippedCount)}, new String[]{"useLatestVersions skipped updating ", " ", " "}).plus("in --ignore-dependency:"));
            DependencyUpdate dependencyLeftToUpdate3 = null;
            for (DependencyUpdate dependencyLeftToUpdate3 : leftToUpdate) {
                if (!(this.updateBlacklist.contains(dependencyLeftToUpdate3.groupAndName()) || this.updateBlacklist.contains(dependencyLeftToUpdate3.getGroup()))) continue;
                DefaultGroovyMethods.println((Object)((Object)this), (Object)StringGroovyMethods.plus((CharSequence)" - ", (Object)dependencyLeftToUpdate3));
            }
        }
    }

    private int getSkippedCount(List<DependencyUpdate> leftToUpdate) {
        int skippedCount = 0;
        if (!this.updateWhitelist.isEmpty()) {
            int n;
            public final class _getSkippedCount_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getSkippedCount_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return !((UseLatestVersionsCheckTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), UseLatestVersionsCheckTask.class))).getUpdateWhitelist().contains(((DependencyUpdate)it).groupAndName()) && !((UseLatestVersionsCheckTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), UseLatestVersionsCheckTask.class))).getUpdateWhitelist().contains(((DependencyUpdate)it).getGroup());
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSkippedCount_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            skippedCount = n = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.count(leftToUpdate, (Closure)new _getSkippedCount_closure1((Object)this, (Object)this)), Integer.TYPE));
        }
        if (!this.updateBlacklist.isEmpty()) {
            int n;
            public final class _getSkippedCount_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getSkippedCount_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((UseLatestVersionsCheckTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), UseLatestVersionsCheckTask.class))).getUpdateBlacklist().contains(((DependencyUpdate)it).groupAndName()) || ((UseLatestVersionsCheckTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), UseLatestVersionsCheckTask.class))).getUpdateBlacklist().contains(((DependencyUpdate)it).getGroup());
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSkippedCount_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            skippedCount = n = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.count(leftToUpdate, (Closure)new _getSkippedCount_closure2((Object)this, (Object)this)), Integer.TYPE));
        }
        return skippedCount;
    }

    private void validateExclusiveWhiteOrBlacklist() {
        if (!this.updateWhitelist.isEmpty() && !this.updateBlacklist.isEmpty()) {
            throw (Throwable)new GradleException(Common.WHITE_BLACKLIST_ERROR_MESSAGE);
        }
    }

    public static String deps(int i) {
        if (i == 1) {
            return "dependency";
        }
        return "dependencies";
    }

    public static /* synthetic */ List<String> pfaccess$0(UseLatestVersionsCheckTask $that) {
        return $that.getUpdateWhitelist();
    }

    public static /* synthetic */ List<String> pfaccess$1(UseLatestVersionsCheckTask $that) {
        return $that.getUpdateBlacklist();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != UseLatestVersionsCheckTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public List<String> getUpdateWhitelist() {
        return this.updateWhitelist;
    }

    @Generated
    public void setUpdateWhitelist(List<String> list) {
        this.updateWhitelist = list;
    }

    @Generated
    public List<String> getUpdateBlacklist() {
        return this.updateBlacklist;
    }

    @Generated
    public void setUpdateBlacklist(List<String> list) {
        this.updateBlacklist = list;
    }
}

