/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import se.l4.commons.serialization.Named;
import se.l4.commons.serialization.QualifiedName;
import se.l4.commons.serialization.SerializationException;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerCollection;
import se.l4.commons.serialization.SerializerOrResolver;
import se.l4.commons.serialization.internal.DelayedSerializer;
import se.l4.commons.serialization.internal.TypeEncounterImpl;
import se.l4.commons.serialization.spi.SerializerResolver;
import se.l4.commons.serialization.spi.StaticSerializerResolver;
import se.l4.commons.serialization.spi.Type;
import se.l4.commons.serialization.spi.TypeViaClass;

public abstract class AbstractSerializerCollection
implements SerializerCollection {
    private static final ThreadLocal<Set<Type>> stack = new ThreadLocal();
    private final Map<QualifiedName, Serializer<?>> nameToSerializer = new ConcurrentHashMap();
    private final Map<Serializer<?>, QualifiedName> serializerToName = new ConcurrentHashMap();
    private final Map<CacheKey, Serializer<?>> serializers = new ConcurrentHashMap();

    protected <T> void bind(Class<T> type, Serializer<T> serializer, String ns, String name) {
        this.bind(type, new StaticSerializerResolver<T>(serializer));
        QualifiedName qname = new QualifiedName(ns, name);
        this.nameToSerializer.put(qname, serializer);
        this.serializerToName.put(serializer, qname);
    }

    @Override
    public SerializerCollection bind(Class<?> type) {
        this.find(type);
        return this;
    }

    @Override
    public <T> SerializerCollection bind(Class<T> type, Serializer<T> serializer) {
        this.bind(type, new StaticSerializerResolver<T>(serializer));
        this.registerIfNamed(type, serializer);
        return this;
    }

    @Override
    public <T> Serializer<T> find(Class<T> type) {
        return this.find(new TypeViaClass(type));
    }

    @Override
    public <T> Serializer<T> find(Class<T> type, Annotation ... hints) {
        return this.find(new TypeViaClass(type), hints);
    }

    @Override
    public Serializer<?> find(Type type) {
        return this.find(type, (Annotation[])null);
    }

    @Override
    public Serializer<?> find(Type type, Annotation ... hints) {
        Set<Type> s = stack.get();
        if (s != null && s.contains(type)) {
            return new DelayedSerializer(this, type, hints);
        }
        SerializerResolver<?> finder = this.getResolver(type.getErasedType());
        if (finder == null) {
            throw new SerializationException("Unable to retreive serializer for " + type + "; Type does not appear serializable");
        }
        return this.createVia(finder, type, hints);
    }

    @Override
    public Serializer<?> find(String name) {
        return this.find("", name);
    }

    @Override
    public Serializer<?> find(String namespace, String name) {
        return this.nameToSerializer.get(new QualifiedName(namespace, name));
    }

    @Override
    public <T> Serializer<T> findVia(Class<? extends SerializerOrResolver<T>> resolver, Class<T> type, Annotation ... hints) {
        return this.findVia(resolver, new TypeViaClass(type), hints);
    }

    @Override
    public <T> Serializer<T> findVia(Class<? extends SerializerOrResolver<T>> resolver, Type type, Annotation ... hints) {
        SerializerOrResolver<T> instance = this.getInstanceFactory().create(resolver);
        if (instance instanceof Serializer) {
            return (Serializer)instance;
        }
        return this.createVia((SerializerResolver)instance, type, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializer<?> createVia(SerializerResolver<?> resolver, Type type, Annotation ... hints) {
        List<Annotation> hintsActive;
        Set<Type> s = stack.get();
        Set<Class<Annotation>> hintsUsed = resolver.getHints();
        if (hintsUsed == null || hints == null || hints.length == 0) {
            hintsActive = Collections.emptyList();
        } else {
            hintsActive = new ArrayList();
            for (Annotation a : hints) {
                if (!hintsUsed.contains(a.annotationType())) continue;
                hintsActive.add(a);
            }
        }
        CacheKey key = new CacheKey(type, hintsActive.toArray());
        Serializer<?> serializer = this.serializers.get(key);
        if (serializer != null) {
            return serializer;
        }
        if (s == null) {
            s = new HashSet<Type>();
            stack.set(s);
        }
        try {
            s.add(type);
            TypeEncounterImpl encounter = new TypeEncounterImpl(this, type, hintsActive);
            serializer = resolver.find(encounter);
            if (serializer == null) {
                throw new SerializationException("Unable to find serializer for " + type + " using " + resolver.getClass());
            }
            this.registerIfNamed(type.getErasedType(), serializer);
            this.serializers.put(key, serializer);
            Serializer<?> serializer2 = serializer;
            return serializer2;
        }
        finally {
            s.remove(type);
            if (s.isEmpty()) {
                stack.remove();
            }
        }
    }

    @Override
    public QualifiedName findName(Serializer<?> serializer) {
        return this.serializerToName.get(serializer);
    }

    @Override
    public boolean isSupported(Class<?> type) {
        SerializerResolver<?> finder = this.getResolver(type);
        if (finder == null) {
            return false;
        }
        if (finder instanceof StaticSerializerResolver) {
            return true;
        }
        Serializer<?> serializer = finder.find(new TypeEncounterImpl(this, new TypeViaClass(type), null));
        return serializer != null;
    }

    protected void registerIfNamed(Class<?> from, Serializer<?> serializer) {
        if (from.isAnnotationPresent(Named.class)) {
            Named named = from.getAnnotation(Named.class);
            QualifiedName key = new QualifiedName(named.namespace(), named.name());
            this.nameToSerializer.put(key, serializer);
            this.serializerToName.put(serializer, key);
        }
    }

    private static class CacheKey {
        private final Type type;
        private final Object[] hints;

        public CacheKey(Type type, Object[] hints) {
            this.type = type;
            this.hints = hints;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.hints);
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (!Arrays.equals(this.hints, other.hints)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

