/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config.internal.streaming;

import java.io.IOException;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.Token;

public class NullInput
implements StreamingInput {
    private boolean used;
    private String key;

    public NullInput(String key) {
        this.key = key;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Token peek() throws IOException {
        return this.used ? null : Token.NULL;
    }

    @Override
    public Token next() throws IOException {
        if (this.used) {
            return null;
        }
        this.used = true;
        return Token.NULL;
    }

    @Override
    public Token next(Token expected) throws IOException {
        Token token = this.next();
        if (expected != Token.NULL) {
            throw new IOException(this.key + ": Expected " + (Object)((Object)expected) + " but got " + (Object)((Object)token));
        }
        return token;
    }

    @Override
    public void skip() throws IOException {
    }

    @Override
    public void skipValue() throws IOException {
    }

    @Override
    public Token current() {
        return Token.NULL;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public String getString() {
        return null;
    }

    @Override
    public boolean getBoolean() {
        return false;
    }

    @Override
    public double getDouble() {
        return 0.0;
    }

    @Override
    public float getFloat() {
        return 0.0f;
    }

    @Override
    public long getLong() {
        return 0L;
    }

    @Override
    public int getInt() {
        return 0;
    }

    @Override
    public short getShort() {
        return 0;
    }

    @Override
    public byte[] getByteArray() {
        return null;
    }
}

