/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.spi;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import se.l4.commons.serialization.SerializationException;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerOrResolver;
import se.l4.commons.serialization.Use;
import se.l4.commons.serialization.collections.ArraySerializerResolver;
import se.l4.commons.serialization.spi.NamingCallback;
import se.l4.commons.serialization.spi.SerializerResolver;
import se.l4.commons.serialization.spi.SerializerResolverChain;
import se.l4.commons.serialization.spi.StaticSerializerResolver;
import se.l4.commons.types.InstanceFactory;

public class SerializerResolverRegistry {
    private static final SerializerResolver<?> ARRAY_RESOLVER = new ArraySerializerResolver();
    private final InstanceFactory instanceFactory;
    private final NamingCallback naming;
    private final Map<Class<?>, SerializerResolver<?>> boundTypeToResolver;
    private final LoadingCache<Class<?>, Optional<SerializerResolver<?>>> typeToResolverCache;

    public SerializerResolverRegistry(InstanceFactory instanceFactory, NamingCallback naming) {
        this.instanceFactory = instanceFactory;
        this.naming = naming;
        this.boundTypeToResolver = new ConcurrentHashMap();
        this.typeToResolverCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<SerializerResolver<?>>>(){

            public Optional<SerializerResolver<?>> load(Class<?> key) throws Exception {
                SerializerResolver<?> result = SerializerResolverRegistry.this.findOrCreateSerializerResolver(key);
                return Optional.ofNullable(result);
            }
        });
    }

    public <T> void bind(Class<T> type, SerializerResolver<? extends T> resolver) {
        this.typeToResolverCache.put(type, Optional.of(resolver));
        this.boundTypeToResolver.put(type, resolver);
    }

    public SerializerResolver<?> getResolver(Class<?> type) {
        try {
            Optional optional = (Optional)this.typeToResolverCache.get((Object)Primitives.wrap(type));
            return optional.isPresent() ? (SerializerResolver)optional.get() : null;
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), SerializationException.class);
            throw new SerializationException("Unable to retrieve serializer for " + type + "; " + e.getCause().getMessage(), e.getCause());
        }
    }

    protected SerializerResolver<?> findOrCreateSerializerResolver(Class<?> from) {
        SerializerResolver<?> resolver = this.createViaUse(from);
        if (resolver != null) {
            return resolver;
        }
        if (from.isArray()) {
            return ARRAY_RESOLVER;
        }
        LinkedHashSet resolvers = Sets.newLinkedHashSet();
        this.findSerializerResolver(from, resolvers);
        if (resolvers.isEmpty()) {
            return null;
        }
        if (resolvers.size() == 1) {
            return (SerializerResolver)resolvers.iterator().next();
        }
        return new SerializerResolverChain(resolvers);
    }

    protected void findSerializerResolver(Class<?> type, Set<SerializerResolver<?>> resolvers) {
        for (Class<?> parent = type; parent != null; parent = parent.getSuperclass()) {
            SerializerResolver<?> resolver = this.boundTypeToResolver.get(parent);
            if (resolver != null) {
                resolvers.add(resolver);
            }
            this.findSerializerResolverViaInterfaces(parent, resolvers);
        }
    }

    protected void findSerializerResolverViaInterfaces(Class<?> type, Set<SerializerResolver<?>> resolvers) {
        Class<?>[] interfaces;
        for (Class<?> intf : interfaces = type.getInterfaces()) {
            SerializerResolver<?> resolver = this.boundTypeToResolver.get(intf);
            if (resolver == null) continue;
            resolvers.add(resolver);
        }
        for (Class<?> intf : interfaces) {
            this.findSerializerResolverViaInterfaces(intf, resolvers);
        }
    }

    protected SerializerResolver<?> createViaUse(Class<?> from) {
        if (from.isAnnotationPresent(Use.class)) {
            Use annotation = from.getAnnotation(Use.class);
            Class<? extends SerializerOrResolver> value = annotation.value();
            if (SerializerResolver.class.isAssignableFrom(value)) {
                return (SerializerResolver)this.instanceFactory.create(value);
            }
            Serializer serializer = (Serializer)this.instanceFactory.create(value);
            this.naming.registerIfNamed(from, serializer);
            return new StaticSerializerResolver(serializer);
        }
        return null;
    }
}

