/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.spi;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.spi.SerializerResolver;
import se.l4.commons.serialization.spi.TypeEncounter;

public class SerializerResolverChain<T>
implements SerializerResolver<T> {
    private final SerializerResolver<T>[] resolvers;
    private final Set<Class<? extends Annotation>> hints;

    public SerializerResolverChain(Collection<SerializerResolver<T>> resolvers) {
        int i = 0;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        SerializerResolver[] resolverArray = new SerializerResolver[resolvers.size()];
        for (SerializerResolver<T> r : resolvers) {
            resolverArray[i++] = r;
            builder.addAll(r.getHints());
        }
        this.hints = builder.build();
        this.resolvers = resolverArray;
    }

    @Override
    public Serializer<T> find(TypeEncounter encounter) {
        for (SerializerResolver<T> resolver : this.resolvers) {
            Serializer<T> serializer = resolver.find(encounter);
            if (serializer == null) continue;
            return serializer;
        }
        return null;
    }

    @Override
    public Set<Class<? extends Annotation>> getHints() {
        return this.hints;
    }
}

