/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.internal.reflection;

import java.io.IOException;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;
import se.l4.commons.serialization.internal.reflection.FieldDefinition;
import se.l4.commons.serialization.internal.reflection.TypeInfo;

public class ReflectionStreamingSerializer<T>
implements Serializer<T> {
    private final TypeInfo<T> type;

    public ReflectionStreamingSerializer(TypeInfo<T> type) {
        this.type = type;
    }

    @Override
    public T read(StreamingInput in) throws IOException {
        in.next(Token.OBJECT_START);
        T instance = this.type.newInstance(null);
        while (in.peek() != Token.OBJECT_END) {
            in.next(Token.KEY);
            String key = in.getString();
            FieldDefinition def = this.type.getField(key);
            if (def == null) {
                in.skipValue();
                continue;
            }
            def.read(instance, in);
        }
        in.next(Token.OBJECT_END);
        return instance;
    }

    @Override
    public void write(T object, String name, StreamingOutput stream) throws IOException {
        stream.writeObjectStart(name);
        for (FieldDefinition def : this.type.getAllFields()) {
            def.write(object, stream);
        }
        stream.writeObjectEnd(name);
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        return this.type.getFormatDefinition();
    }
}

