/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.internal.reflection;

import com.google.common.base.Defaults;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import se.l4.commons.serialization.SerializationException;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;

public class FieldDefinition {
    private final Field field;
    private final Serializer serializer;
    private final String name;
    private final Class<?> type;
    private final boolean readOnly;
    private final boolean skipIfDefault;

    public FieldDefinition(Field field, String name, Serializer serializer, Class type, boolean skipIfDefault) {
        this.field = field;
        this.name = name;
        this.serializer = serializer;
        this.type = type;
        this.skipIfDefault = skipIfDefault;
        this.readOnly = Modifier.isFinal(field.getModifiers());
    }

    public String getName() {
        return this.name;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public boolean isSkipIfDefault() {
        return this.skipIfDefault;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object read(StreamingInput in) throws IOException {
        if (in.peek() == Token.NULL) {
            in.next();
            return null;
        }
        return this.serializer.read(in);
    }

    public void read(Object target, StreamingInput in) throws IOException {
        this.set(target, this.read(in));
    }

    public void set(Object target, Object value) throws IOException {
        try {
            if (value == null && this.type.isPrimitive()) {
                value = Defaults.defaultValue(this.type);
            }
            this.field.set(target, value);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new SerializationException("Unable to read object; " + e.getMessage(), e);
        }
    }

    public Object getValue(Object target) {
        try {
            return this.field.get(target);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("Unable to write object; " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Unable to write object; " + e.getMessage(), e);
        }
    }

    public void write(Object target, StreamingOutput stream) throws IOException {
        Object defaultValue;
        Object value = this.getValue(target);
        if (this.skipIfDefault && Objects.equals(defaultValue = Defaults.defaultValue(this.type), value)) {
            return;
        }
        if (value == null) {
            stream.writeNull(this.name);
        } else {
            this.serializer.write(value, this.name, stream);
        }
    }

    public Annotation[] getHints() {
        return this.field.getAnnotations();
    }
}

