/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.internal.reflection;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedConstructor;
import com.google.common.base.Defaults;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Primitives;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import se.l4.commons.serialization.Expose;
import se.l4.commons.serialization.Factory;
import se.l4.commons.serialization.SerializationException;
import se.l4.commons.serialization.SerializerCollection;
import se.l4.commons.serialization.internal.reflection.FieldDefinition;

public class FactoryDefinition<T> {
    private final SerializerCollection collection;
    final Argument[] arguments;
    private final boolean hasSerializedFields;
    private final boolean isInjectable;
    private final Constructor<?> raw;

    public FactoryDefinition(SerializerCollection collection, Map<String, FieldDefinition> fields, Map<String, FieldDefinition> nonRenamed, ResolvedConstructor constructor) {
        this.collection = collection;
        ArrayList<Argument> args = new ArrayList<Argument>();
        this.raw = (Constructor)constructor.getRawMember();
        ConstructorProperties cp = this.raw.getAnnotation(ConstructorProperties.class);
        String[] names = cp == null ? null : cp.value();
        Annotation[][] annotations = this.raw.getParameterAnnotations();
        boolean hasSerializedFields = false;
        int n = constructor.getArgumentCount();
        for (int i = 0; i < n; ++i) {
            String name;
            FieldDefinition def;
            ResolvedType type = constructor.getArgumentType(i);
            Expose expose = FactoryDefinition.findExpose(annotations[i]);
            if (expose != null) {
                if ("".equals(expose.value())) {
                    throw new SerializationException("The annotation @" + Expose.class.getSimpleName() + " when used in a constructor must have a name (for " + this.raw.getDeclaringClass() + ")");
                }
                FieldDefinition def2 = fields.get(expose.value());
                if (def2 == null) {
                    throw new SerializationException(expose + " was used on a constructor but the there was no such field declared (for " + this.raw.getDeclaringClass() + ")");
                }
                if (Primitives.wrap(def2.getType()) != Primitives.wrap((Class)type.getErasedType())) {
                    throw new SerializationException(expose + " was used on a constructor but the type of the argument was different from the field. The field was resolved to " + def2.getType() + " but the argument was of type " + type.getErasedType() + " (for " + this.raw.getDeclaringClass() + ")");
                }
                args.add(new SerializedArgument(def2.getType(), expose.value()));
                hasSerializedFields = true;
                continue;
            }
            if (names != null && i < names.length && (def = nonRenamed.get(name = names[i])) != null) {
                args.add(new SerializedArgument(def.getType(), def.getName()));
                hasSerializedFields = true;
                continue;
            }
            args.add(new InjectedArgument(type.getErasedType(), annotations[i]));
        }
        boolean isInjectable = args.isEmpty();
        for (Annotation a : ((Constructor)constructor.getRawMember()).getAnnotations()) {
            if (a.annotationType() == Factory.class) {
                isInjectable = true;
                continue;
            }
            if (!a.annotationType().getSimpleName().equals("Inject")) continue;
            isInjectable = true;
        }
        this.arguments = args.toArray(new Argument[args.size()]);
        this.hasSerializedFields = hasSerializedFields;
        this.isInjectable = isInjectable;
    }

    private static Expose findExpose(Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof Expose)) continue;
            return (Expose)a;
        }
        return null;
    }

    public boolean hasSerializedFields() {
        return this.hasSerializedFields;
    }

    public boolean isInjectable() {
        return this.isInjectable;
    }

    public int getFieldCount() {
        int result = 0;
        for (Argument a : this.arguments) {
            if (!(a instanceof SerializedArgument)) continue;
            ++result;
        }
        return result;
    }

    public int getScore(Map<String, Object> data) {
        if (!this.hasSerializedFields) {
            return 0;
        }
        int score = 0;
        for (Argument arg : this.arguments) {
            if (!(arg instanceof SerializedArgument) || !data.containsKey(((SerializedArgument)arg).name)) continue;
            ++score;
        }
        return score;
    }

    public T create(Map<String, Object> data) {
        Object[] args = new Object[this.arguments.length];
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            args[i] = this.arguments[i].getValue(data);
        }
        try {
            return (T)this.raw.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("Unable to create; " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new SerializationException("Unable to create; " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Unable to create; " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException("Unable to create; " + e.getCause().getMessage(), e.getCause());
        }
    }

    public T create(Object[] args) {
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            if (!(this.arguments[i] instanceof InjectedArgument)) continue;
            args[i] = this.arguments[i].getValue(null);
        }
        try {
            return (T)this.raw.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("Unable to create; " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new SerializationException("Unable to create; " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Unable to create; " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException("Unable to create; " + e.getCause().getMessage(), e.getCause());
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("constructor", this.raw).toString();
    }

    private class InjectedArgument
    implements Argument {
        private final Class<?> type;
        private final Annotation[] annotations;

        public InjectedArgument(Class<?> type, Annotation[] annotations) {
            this.type = type;
            this.annotations = annotations;
        }

        @Override
        public Object getValue(Map<String, Object> data) {
            return FactoryDefinition.this.collection.getInstanceFactory().create(this.type, this.annotations);
        }
    }

    class SerializedArgument
    implements Argument {
        final Class<?> type;
        final String name;

        public SerializedArgument(Class<?> type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public Object getValue(Map<String, Object> data) {
            Object value = data.get(this.name);
            if (value == null && this.type.isPrimitive()) {
                return Defaults.defaultValue(this.type);
            }
            return value;
        }
    }

    static interface Argument {
        public Object getValue(Map<String, Object> var1);
    }
}

