/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.collections;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;

public class ListSerializer<T>
implements Serializer<List<T>> {
    private final Serializer<T> itemSerializer;
    private final SerializerFormatDefinition formatDefinition;

    public ListSerializer(Serializer<T> itemSerializer) {
        this.itemSerializer = itemSerializer;
        this.formatDefinition = SerializerFormatDefinition.builder().list(itemSerializer).build();
    }

    @Override
    public List<T> read(StreamingInput in) throws IOException {
        in.next(Token.LIST_START);
        ArrayList<Object> list = new ArrayList<Object>();
        while (in.peek() != Token.LIST_END) {
            Object value;
            if (in.peek() == Token.NULL) {
                in.next();
                value = null;
            } else {
                value = this.itemSerializer.read(in);
            }
            list.add(value);
        }
        in.next(Token.LIST_END);
        return list;
    }

    @Override
    public void write(List<T> object, String name, StreamingOutput stream) throws IOException {
        stream.writeListStart(name);
        if (object instanceof RandomAccess) {
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                T value = object.get(i);
                if (value == null) {
                    stream.writeNull("item");
                    continue;
                }
                this.itemSerializer.write(value, "item", stream);
            }
        } else {
            for (T value : object) {
                if (value == null) {
                    stream.writeNull("item");
                    continue;
                }
                this.itemSerializer.write(value, "item", stream);
            }
        }
        stream.writeListEnd(name);
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        return this.formatDefinition;
    }
}

