/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.collections;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;

public class ArraySerializer
implements Serializer<Object> {
    private final Class<?> componentType;
    private final Serializer itemSerializer;
    private final SerializerFormatDefinition formatDefinition;

    public ArraySerializer(Class<?> componentType, Serializer<?> itemSerializer) {
        this.componentType = componentType;
        this.itemSerializer = itemSerializer;
        this.formatDefinition = SerializerFormatDefinition.builder().list(itemSerializer).build();
    }

    @Override
    public Object read(StreamingInput in) throws IOException {
        in.next(Token.LIST_START);
        ArrayList list = new ArrayList();
        while (in.peek() != Token.LIST_END) {
            if (in.peek() == Token.NULL) {
                in.next(Token.NULL);
                list.add(null);
                continue;
            }
            Object value = this.itemSerializer.read(in);
            list.add(value);
        }
        in.next(Token.LIST_END);
        Object array = Array.newInstance(this.componentType, list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    @Override
    public void write(Object object, String name, StreamingOutput stream) throws IOException {
        stream.writeListStart(name);
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object value = Array.get(object, i);
            if (value == null) {
                stream.writeNull("item");
                continue;
            }
            this.itemSerializer.write(value, "item", stream);
        }
        stream.writeListEnd(name);
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        return this.formatDefinition;
    }
}

