/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.format.ValueType;
import se.l4.commons.serialization.internal.SerializerFormatDefinitionBuilderImpl;
import se.l4.commons.serialization.spi.Type;

public class SerializerFormatDefinition {
    private static final SerializerFormatDefinition ANY = new SerializerFormatDefinition(3, null, Collections.emptyList());
    private static final SerializerFormatDefinition UNKNOWN = new SerializerFormatDefinition(4, null, Collections.emptyList());
    private static final Map<ValueType, SerializerFormatDefinition> VALUES;
    private final int type;
    private final ValueType valueType;
    private final ImmutableMap<String, FieldDefinition> fields;

    public SerializerFormatDefinition(int type, ValueType valueType, Iterable<FieldDefinition> definitions) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FieldDefinition fd : definitions) {
            builder.put((Object)fd.getName(), (Object)fd);
        }
        this.fields = builder.build();
        this.type = type;
        this.valueType = valueType;
    }

    public FieldDefinition getField(String fieldName) {
        return (FieldDefinition)this.fields.get((Object)fieldName);
    }

    public Collection<FieldDefinition> getFields() {
        return this.fields.values();
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean isList() {
        return this.type == 2;
    }

    public boolean isObject() {
        return this.type == 1;
    }

    public boolean isValue() {
        return this.type == 0;
    }

    public boolean isAny() {
        return this.type == 3;
    }

    public boolean isUnknown() {
        return this.type == 4;
    }

    public static Builder builder() {
        return new SerializerFormatDefinitionBuilderImpl();
    }

    public static SerializerFormatDefinition any() {
        return ANY;
    }

    public static SerializerFormatDefinition unknown() {
        return UNKNOWN;
    }

    public static SerializerFormatDefinition forValue(ValueType value) {
        return VALUES.get((Object)value);
    }

    static {
        EnumMap<ValueType, SerializerFormatDefinition> values = new EnumMap<ValueType, SerializerFormatDefinition>(ValueType.class);
        for (ValueType vt : ValueType.values()) {
            values.put(vt, new SerializerFormatDefinition(0, vt, Collections.emptyList()));
        }
        VALUES = values;
    }

    public static interface FieldBuilder {
        public FieldBuilder withHint(Annotation var1);

        public FieldBuilder withHints(Annotation ... var1);

        public FieldBuilder withType(Class<?> var1);

        public FieldBuilder withType(Type var1);

        public Builder using(Serializer<?> var1);

        public Builder using(SerializerFormatDefinition var1);

        public Builder using(ValueType var1);
    }

    public static interface Builder {
        public Builder object();

        public FieldBuilder field(String var1);

        public Builder value(ValueType var1);

        public Builder list(SerializerFormatDefinition var1);

        public Builder list(Serializer<?> var1);

        public SerializerFormatDefinition build();
    }

    public static class FieldDefinition {
        private final String name;
        private final SerializerFormatDefinition definition;
        private final Type type;
        private final Annotation[] hints;

        public FieldDefinition(String name, SerializerFormatDefinition definition, Type type, Annotation[] hints) {
            this.name = name;
            this.definition = definition;
            this.type = type;
            this.hints = hints;
        }

        public String getName() {
            return this.name;
        }

        public SerializerFormatDefinition getDefinition() {
            return this.definition;
        }

        public Type getType() {
            return this.type;
        }

        public Annotation[] getHints() {
            return this.hints;
        }
    }
}

