/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Function;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.SerializerOrResolver;
import se.l4.commons.serialization.format.BinaryInput;
import se.l4.commons.serialization.format.BinaryOutput;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;

public interface Serializer<T>
extends SerializerOrResolver<T> {
    public T read(StreamingInput var1) throws IOException;

    public void write(T var1, String var2, StreamingOutput var3) throws IOException;

    default public SerializerFormatDefinition getFormatDefinition() {
        return SerializerFormatDefinition.unknown();
    }

    default public byte[] toBytes(T instance) {
        if (instance == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            BinaryOutput out = new BinaryOutput(baos);
            this.write(instance, "root", out);
            out.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    default public Function<T, byte[]> toBytes() {
        return this::toBytes;
    }

    default public T fromBytes(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            BinaryInput bin = new BinaryInput(in);
            return this.read(bin);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    default public Function<byte[], T> fromBytes() {
        return this::fromBytes;
    }
}

