/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import se.l4.commons.io.Bytes;
import se.l4.commons.io.IoSupplier;

public class InputStreamBytes
implements Bytes {
    private final IoSupplier<InputStream> in;

    public InputStreamBytes(IoSupplier<InputStream> in) {
        this.in = in;
    }

    @Override
    public InputStream asInputStream() throws IOException {
        return this.in.get();
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = this.in.get();){
            int read;
            byte[] data = new byte[8192];
            while ((read = in.read(data)) != -1) {
                out.write(data, 0, read);
            }
        }
        return out.toByteArray();
    }
}

