/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config.internal.streaming;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import se.l4.commons.config.internal.streaming.MapInput;
import se.l4.commons.serialization.format.AbstractStreamingInput;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.Token;

public class ListInput
extends AbstractStreamingInput {
    private State state;
    private State previousState;
    private Iterator<Object> iterator;
    private Object object;
    private StreamingInput subInput;
    private String key;

    public ListInput(String key, List<Object> root) {
        this.key = key;
        this.state = State.START;
        this.iterator = root.iterator();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    protected IOException raiseException(String message) {
        return new IOException(this.key + ": " + message);
    }

    @Override
    public Token peek() throws IOException {
        switch (this.state) {
            case START: {
                return Token.LIST_START;
            }
            case VALUE: {
                Token peeked = this.subInput.peek();
                if (peeked != null) {
                    return peeked;
                }
                this.advancePosition();
                return this.peek();
            }
            case END: {
                return Token.LIST_END;
            }
        }
        return null;
    }

    @Override
    public Token next0() throws IOException {
        switch (this.state) {
            case START: {
                this.advancePosition();
                return Token.LIST_START;
            }
            case VALUE: {
                Token t = this.subInput.next();
                if (t == null) {
                    this.advancePosition();
                    return this.next();
                }
                this.setState(State.VALUE);
                return t;
            }
            case END: {
                this.setState(State.DONE);
                return Token.LIST_END;
            }
        }
        return null;
    }

    private void setState(State state) {
        this.previousState = this.state;
        this.state = state;
    }

    private void advancePosition() {
        if (this.iterator.hasNext()) {
            this.object = this.iterator.next();
            this.subInput = MapInput.resolveInput(this.key, this.object);
            this.setState(State.VALUE);
        } else {
            this.setState(State.END);
        }
    }

    @Override
    public Token current() {
        return this.subInput != null ? this.subInput.current() : super.current();
    }

    @Override
    public Object getValue() {
        switch (this.previousState) {
            case VALUE: {
                return this.subInput.getValue();
            }
        }
        return null;
    }

    @Override
    public String getString() {
        switch (this.state) {
            case VALUE: {
                return this.subInput.getString();
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean() {
        switch (this.state) {
            case VALUE: {
                return this.subInput.getBoolean();
            }
        }
        return false;
    }

    @Override
    public double getDouble() {
        switch (this.state) {
            case VALUE: {
                return this.subInput.getDouble();
            }
        }
        return 0.0;
    }

    @Override
    public float getFloat() {
        switch (this.state) {
            case VALUE: {
                return this.subInput.getFloat();
            }
        }
        return 0.0f;
    }

    @Override
    public long getLong() {
        switch (this.state) {
            case VALUE: {
                return this.subInput.getLong();
            }
        }
        return 0L;
    }

    @Override
    public int getInt() {
        switch (this.state) {
            case VALUE: {
                return this.subInput.getInt();
            }
        }
        return 0;
    }

    @Override
    public short getShort() {
        switch (this.state) {
            case VALUE: {
                return this.subInput.getShort();
            }
        }
        return 0;
    }

    private static enum State {
        START,
        VALUE,
        END,
        DONE;

    }
}

