/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.l4.commons.serialization.SerializationException;

public class ConfigResolver {
    private ConfigResolver() {
    }

    public static Map<String, Object> resolve(Map<String, Object> root) {
        HashMap<String, Object> newRoot = new HashMap<String, Object>();
        ConfigResolver.resolve(newRoot, root, "");
        return newRoot;
    }

    public static Map<String, Object> resolveTo(Map<String, Object> root, Map<String, Object> target) {
        ConfigResolver.resolve(target, root, "");
        return target;
    }

    private static void resolve(Map<String, Object> newRoot, Map<String, Object> root, String currentKey) {
        for (Map.Entry<String, Object> e : root.entrySet()) {
            String newKey;
            String key = e.getKey();
            Object value = e.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                newKey = currentKey.isEmpty() ? key : currentKey + '.' + key;
                map.put("_aurochs_:configKey", newKey);
                ConfigResolver.resolve(map, (Map)value, newKey);
                ConfigResolver.store(newRoot, key, map, currentKey);
                continue;
            }
            if (value instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>();
                newKey = currentKey.isEmpty() ? key : currentKey + '.' + key;
                ConfigResolver.resolve(list, (List)value, newKey);
                ConfigResolver.store(newRoot, key, list, currentKey);
                continue;
            }
            ConfigResolver.store(newRoot, key, value, currentKey);
        }
    }

    private static void resolve(List<Object> newList, List<Object> oldList, String currentKey) {
        int n = oldList.size();
        for (int i = 0; i < n; ++i) {
            String newKey = currentKey + '[' + i + ']';
            Cloneable value = oldList.get(i);
            if (value instanceof Map) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("_aurochs_:configKey", newKey);
                ConfigResolver.resolve(map, (Map)((Object)value), newKey);
                value = map;
            } else if (value instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>();
                ConfigResolver.resolve(list, (List<Object>)((Object)value), newKey);
                value = list;
            }
            newList.add(value);
        }
    }

    private static void store(Map<String, Object> root, String key, Object value, String currentKey) {
        HashMap<String, Object> current = root;
        if (key.startsWith("\"")) {
            root.put(key.substring(1, key.length() - 1), value);
            return;
        }
        String[] path = key.split("\\.");
        StringBuilder resolvedPath = new StringBuilder(currentKey);
        int n = path.length - 1;
        for (int i = 0; i < n; ++i) {
            if (current.containsKey(path[i])) {
                Object o = current.get(path[i]);
                if (o instanceof Map) {
                    current = (HashMap<String, Object>)o;
                    continue;
                }
                throw new SerializationException();
            }
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            if (resolvedPath.length() > 0) {
                resolvedPath.append('.');
            }
            resolvedPath.append(path[i]);
            newMap.put("_aurochs_:configKey", resolvedPath.toString());
            current.put(path[i], newMap);
            current = newMap;
        }
        current.put(path[path.length - 1], value);
    }
}

