/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ValidatorFactory;
import se.l4.commons.config.Config;
import se.l4.commons.config.ConfigBuilder;
import se.l4.commons.config.ConfigException;
import se.l4.commons.config.internal.ConfigResolver;
import se.l4.commons.config.internal.DefaultConfig;
import se.l4.commons.config.internal.RawFormatReader;
import se.l4.commons.io.Bytes;
import se.l4.commons.serialization.DefaultSerializerCollection;
import se.l4.commons.serialization.SerializerCollection;

public class ConfigBuilderImpl
implements ConfigBuilder {
    private final List<Bytes> suppliers = new ArrayList<Bytes>();
    private SerializerCollection collection = new DefaultSerializerCollection();
    private ValidatorFactory validatorFactory;
    private File root;

    @Override
    public ConfigBuilder withSerializerCollection(SerializerCollection serializers) {
        this.collection = serializers;
        return this;
    }

    @Override
    public ConfigBuilder withValidatorFactory(ValidatorFactory validation) {
        this.validatorFactory = validation;
        return this;
    }

    @Override
    public ConfigBuilder withRoot(String root) {
        return this.withRoot(new File(root));
    }

    @Override
    public ConfigBuilder withRoot(Path path) {
        return this.withRoot(path.toFile());
    }

    @Override
    public ConfigBuilder withRoot(File root) {
        this.root = root;
        return this;
    }

    @Override
    public ConfigBuilder addFile(String path) {
        return this.addFile(new File(path));
    }

    @Override
    public ConfigBuilder addFile(Path path) {
        return this.addFile(path.toFile());
    }

    @Override
    public ConfigBuilder addFile(File file) {
        if (this.root == null) {
            this.root = file.getParentFile();
        }
        this.suppliers.add(Bytes.create(() -> {
            if (!file.exists()) {
                throw new ConfigException("The file " + file + " does not exist");
            }
            if (!file.isFile()) {
                throw new ConfigException(file + " is not a file");
            }
            if (!file.canRead()) {
                throw new ConfigException("Can not read " + file + ", check permissions");
            }
            return new FileInputStream(file);
        }));
        return this;
    }

    @Override
    public ConfigBuilder addStream(InputStream stream) {
        this.suppliers.add(Bytes.create(() -> stream));
        return this;
    }

    @Override
    public Config build() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Bytes bytes : this.suppliers) {
            try {
                InputStream in = bytes.asInputStream();
                Throwable throwable = null;
                try {
                    Map<String, Object> readConfig = RawFormatReader.read(in);
                    ConfigResolver.resolveTo(readConfig, data);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                throw new ConfigException("Unable to read configuration; " + e.getMessage(), e);
            }
        }
        return new DefaultConfig(this.collection, this.validatorFactory, this.root, data);
    }
}

