/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.collections;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Set;
import se.l4.commons.serialization.SerializationException;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.collections.AllowAnyItem;
import se.l4.commons.serialization.collections.CollectionSerializers;
import se.l4.commons.serialization.collections.Item;
import se.l4.commons.serialization.collections.SetSerializer;
import se.l4.commons.serialization.spi.AbstractSerializerResolver;
import se.l4.commons.serialization.spi.Type;
import se.l4.commons.serialization.spi.TypeEncounter;
import se.l4.commons.serialization.spi.TypeViaClass;

public class SetSerializerResolver
extends AbstractSerializerResolver<Set<?>> {
    private static final Set<Class<? extends Annotation>> HINTS = ImmutableSet.of(AllowAnyItem.class, Item.class);

    @Override
    public Serializer<Set<?>> find(TypeEncounter encounter) {
        Type[] params = encounter.getType().getParameters();
        Type type = params.length == 0 ? new TypeViaClass(Object.class) : params[0];
        Class<?> erasedType = encounter.getType().getErasedType();
        if (erasedType != Set.class) {
            throw new SerializationException("Sets can only be serialized if they are declared as the interface Set");
        }
        Serializer<?> itemSerializer = CollectionSerializers.resolveSerializer(encounter, type);
        return new SetSerializer(itemSerializer);
    }

    @Override
    public Set<Class<? extends Annotation>> getHints() {
        return HINTS;
    }
}

