/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import se.l4.commons.io.Bytes;
import se.l4.commons.io.ExtendedDataOutput;

public class ExtendedDataOutputStream
extends DataOutputStream
implements ExtendedDataOutput {
    public ExtendedDataOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void writeVInt(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) break;
            this.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.write(value);
    }

    @Override
    public void writeVLong(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.write((int)value);
    }

    @Override
    public void writeString(String string) throws IOException {
        this.writeVInt(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                this.out.write((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.out.write((byte)(0xE0 | c >> 12 & 0xF));
                this.out.write((byte)(0x80 | c >> 6 & 0x3F));
                this.out.write((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.out.write((byte)(0xC0 | c >> 6 & 0x1F));
            this.out.write((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    @Override
    public void writeBytes(Bytes bytes) throws IOException {
        bytes.asChunks(8192, (data, offset, len) -> {
            this.writeVInt(len);
            this.write(data, offset, len);
        });
        this.writeVInt(0);
    }
}

