/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.id;

import java.time.Clock;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import se.l4.commons.id.LongIdGenerator;

public class SequenceLongIdGenerator
implements LongIdGenerator {
    public static final int MAX_SEQUENCE = (int)Math.pow(2.0, 21.0);
    private volatile int sequence;
    private volatile long lastTime;
    private final Clock clock;
    private final Lock lock;

    public SequenceLongIdGenerator() {
        this(Clock.systemUTC());
    }

    public SequenceLongIdGenerator(Clock clock) {
        this.clock = clock;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next() {
        this.lock.lock();
        try {
            long time = this.clock.millis() - 1356998400000L;
            if (this.lastTime > time) {
                throw new Error("Time on system is moving backwards, please update system configuration");
            }
            if (this.sequence >= MAX_SEQUENCE) {
                long timeRightNow;
                do {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Interrupted id generation; " + e.getMessage(), e);
                    }
                } while ((timeRightNow = this.clock.millis() - 1356998400000L) == time);
                time = timeRightNow;
            }
            if (this.lastTime != time) {
                this.lastTime = time;
                this.sequence = 0;
            }
            ++this.sequence;
            long l = time << 22 | (long)this.sequence;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

