/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import se.l4.commons.config.Config;
import se.l4.commons.config.ConfigException;
import se.l4.commons.config.ConfigKey;
import se.l4.commons.config.Value;
import se.l4.commons.config.internal.FileSerializer;
import se.l4.commons.config.internal.streaming.MapInput;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerCollection;
import se.l4.commons.serialization.WrappedSerializerCollection;
import se.l4.commons.serialization.format.StreamingInput;

public class DefaultConfig
implements Config {
    private final SerializerCollection collection;
    private final Map<String, Object> data;
    private final ValidatorFactory validatorFactory;
    private static final Pattern LIST_GET = Pattern.compile("(.+)(?:\\[([0-9]+)\\])+");

    public DefaultConfig(SerializerCollection collection, ValidatorFactory validatorFactory, File root, Map<String, Object> data) {
        this.collection = new WrappedSerializerCollection(collection);
        this.validatorFactory = validatorFactory;
        this.data = data;
        collection.bind(File.class, new FileSerializer(root));
        collection.bind(ConfigKey.class, new ConfigKey.ConfigKeySerializer(this));
    }

    private String get(String path, int start, int end) {
        if (path.charAt(start) == '\"') {
            ++start;
        }
        if (path.charAt(end - 1) == '\"') {
            --end;
        }
        return path.substring(start, end);
    }

    private Object get(String path) {
        if (path == null || path.equals("")) {
            return this.data;
        }
        ArrayList parts = Lists.newArrayList();
        boolean quoted = false;
        int lastIndex = 0;
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            char c = path.charAt(i);
            if (!quoted && c == '.') {
                parts.add(this.get(path, lastIndex, i));
                lastIndex = i + 1;
            }
            if (c != '\"') continue;
            quoted = !quoted;
        }
        parts.add(this.get(path, lastIndex, path.length()));
        Map current = this.data;
        int n2 = parts.size();
        for (int i = 0; i < n2; ++i) {
            String part = (String)parts.get(i);
            Matcher listGetMatcher = LIST_GET.matcher(part);
            if (listGetMatcher.matches()) {
                String name = listGetMatcher.group(1);
                Object o = current.get(name);
                if (o == null) {
                    return null;
                }
                if (!(o instanceof List)) {
                    String subPath = Joiner.on((char)'.').join(parts.subList(i + 1, parts.size()));
                    throw new ConfigException("Expected list at `" + subPath + "` but got: " + o);
                }
                List currentList = (List)o;
                String[] indexes = listGetMatcher.group(2).split(" ");
                int m = indexes.length;
                for (int j = 0; j < m; ++j) {
                    int idx = Integer.parseInt(indexes[j]);
                    if (currentList.size() <= idx) {
                        String subPath = Joiner.on((char)'.').join(parts.subList(i + 1, parts.size()));
                        throw new ConfigException("Expected list at `" + subPath + "` to contain at least " + (idx + 1) + " values");
                    }
                    o = currentList.get(idx);
                    if (!(o instanceof List) || j >= m - 1) continue;
                    currentList = (List)o;
                }
                if (i == n2 - 1) {
                    return o;
                }
                if (o instanceof Map) {
                    current = (Map)o;
                    continue;
                }
                String subPath = Joiner.on((char)'.').join(parts.subList(i + 1, parts.size()));
                throw new ConfigException("Expected several values at `" + subPath + "` but only got a single value: " + o);
            }
            if (current.containsKey(part)) {
                if (i == n2 - 1) {
                    return current.get(part);
                }
                Object o = current.get(part);
                if (o instanceof Map) {
                    current = (Map)o;
                    continue;
                }
                String subPath = Joiner.on((char)'.').join(parts.subList(i + 1, parts.size()));
                throw new ConfigException("Expected several values at `" + subPath + "` but only got a single value: " + o);
            }
            return null;
        }
        return current.get(parts.get(parts.size() - 1));
    }

    @Override
    public <T> T asObject(String path, Class<T> type) {
        return this.get(path, type).getOrDefault(null);
    }

    @Override
    public Collection<String> keys(String path) {
        if (path == null || path.equals("")) {
            return this.data.keySet();
        }
        String[] parts = path.split("\\.");
        Map current = this.data;
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            Object o;
            if (current.containsKey(parts[i])) {
                o = current.get(parts[i]);
                if (!(o instanceof Map)) {
                    return Collections.emptyList();
                }
            } else {
                return Collections.emptyList();
            }
            current = (Map)o;
        }
        return Collections2.filter(current.keySet(), s -> !s.startsWith("_aurochs_:"));
    }

    private void validateInstance(String path, Object object) {
        if (this.validatorFactory == null) {
            return;
        }
        Validator validator = this.validatorFactory.getValidator();
        Set violations = validator.validate(object, new Class[0]);
        if (violations.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder("Validation failed for `" + path + "`:\n");
        for (ConstraintViolation violation : violations) {
            builder.append("* ").append(this.join(violation.getPropertyPath())).append(violation.getMessage()).append("\n");
        }
        throw new ConfigException(builder.toString());
    }

    private String join(Path path) {
        StringBuilder builder = new StringBuilder();
        for (Path.Node node : path) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(node.getName());
        }
        if (builder.length() > 0) {
            builder.append(": ");
        }
        return builder.toString();
    }

    @Override
    public <T> Value<T> get(String path, Class<T> type) {
        Serializer<T> serializer = this.collection.find(type);
        if (serializer == null) {
            throw new ConfigException("Unable to find a serializer suitable for " + type);
        }
        Object data = this.get(path);
        if (data == null) {
            return new ValueImpl<Object>(path, false, null);
        }
        StreamingInput input = MapInput.resolveInput(path, data);
        try {
            T instance = serializer.read(input);
            this.validateInstance(path, instance);
            return new ValueImpl<T>(path, true, instance);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException("Unable to create " + type + " from data at `" + path + "`; " + e.getMessage(), e);
        }
    }

    private static class ValueImpl<T>
    implements Value<T> {
        private final String path;
        private final boolean exists;
        private final T instance;

        public ValueImpl(String path, boolean exists, T instance) {
            this.path = path;
            this.exists = exists;
            this.instance = instance;
        }

        @Override
        public T get() {
            if (!this.exists) {
                throw new ConfigException("Unable to get config value at `" + this.path + "`");
            }
            return this.instance;
        }

        @Override
        public T getOrDefault(T defaultInstance) {
            return this.exists ? this.instance : defaultInstance;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }
    }
}

