/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import se.l4.commons.io.ByteArrayConsumer;

public class ChunkOutputStream
extends OutputStream {
    private final ByteArrayConsumer out;
    private final byte[] buffer;
    private int len;

    public ChunkOutputStream(int size, ByteArrayConsumer out) {
        this.out = out;
        this.buffer = new byte[size];
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.len++] = (byte)b;
        if (this.len == this.buffer.length) {
            this.out.consume(this.buffer, 0, this.len);
            this.len = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.len != 0) {
            this.out.consume(this.buffer, 0, this.len);
            this.len = 0;
        }
    }
}

