/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.enums;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Set;
import se.l4.commons.serialization.SerializationException;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.enums.EnumSerializer;
import se.l4.commons.serialization.enums.MapEnumVia;
import se.l4.commons.serialization.enums.NameTranslator;
import se.l4.commons.serialization.enums.ValueTranslator;
import se.l4.commons.serialization.spi.AbstractSerializerResolver;
import se.l4.commons.serialization.spi.TypeEncounter;

public class EnumSerializerResolver
extends AbstractSerializerResolver<Enum<?>> {
    private static final Set<Class<? extends Annotation>> HINTS = ImmutableSet.of(MapEnumVia.class);

    @Override
    public Serializer<Enum<?>> find(TypeEncounter encounter) {
        Class<?> type = encounter.getType().getErasedType();
        MapEnumVia hint = encounter.getHint(MapEnumVia.class);
        ValueTranslator translator = hint != null ? this.create(hint.value(), type) : ((hint = type.getAnnotation(MapEnumVia.class)) != null ? this.create(hint.value(), type) : new NameTranslator(type));
        return new EnumSerializer(translator);
    }

    private ValueTranslator create(Class<? extends ValueTranslator> translator, Class<? extends Enum<?>> type) {
        for (Constructor<?> c : translator.getConstructors()) {
            Class<Class> t;
            Class<?>[] types = c.getParameterTypes();
            if (types.length != 1 || !(t = types[0]).isAssignableFrom(Class.class)) continue;
            try {
                return (ValueTranslator)c.newInstance(type);
            }
            catch (InstantiationException e) {
                Throwables.propagateIfInstanceOf((Throwable)e.getCause(), SerializationException.class);
                throw new SerializationException("Unable to create; " + e.getCause().getMessage(), e.getCause());
            }
            catch (Exception e) {
                throw new SerializationException("Unable to create; " + e.getMessage(), e);
            }
        }
        throw new SerializationException("Constructor that takes Enum is required (for " + translator + ")");
    }

    @Override
    public Set<Class<? extends Annotation>> getHints() {
        return HINTS;
    }
}

