/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.format;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import se.l4.commons.serialization.format.StreamingOutput;

public class BinaryOutput
implements StreamingOutput {
    private static final int LEVELS = 20;
    public static final int TAG_KEY = 0;
    public static final int TAG_OBJECT_START = 1;
    public static final int TAG_OBJECT_END = 2;
    public static final int TAG_LIST_START = 3;
    public static final int TAG_LIST_END = 4;
    public static final int TAG_STRING = 10;
    public static final int TAG_INT = 11;
    public static final int TAG_LONG = 12;
    public static final int TAG_NULL = 13;
    public static final int TAG_FLOAT = 14;
    public static final int TAG_DOUBLE = 15;
    public static final int TAG_BOOLEAN = 16;
    public static final int TAG_BYTE_ARRAY = 17;
    public static final int TAG_POSITIVE_INT = 18;
    public static final int TAG_POSITIVE_LONG = 19;
    public static final int TAG_NEGATIVE_INT = 20;
    public static final int TAG_NEGATIVE_LONG = 21;
    private final OutputStream out;
    private boolean[] lists;
    private boolean[] hasData;
    private int level;

    public BinaryOutput(OutputStream out) {
        this.out = out;
        this.lists = new boolean[20];
        this.hasData = new boolean[20];
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void increaseLevel(boolean list) {
        ++this.level;
        if (this.hasData.length == this.level) {
            this.hasData = Arrays.copyOf(this.hasData, this.hasData.length * 2);
            this.lists = Arrays.copyOf(this.lists, this.hasData.length * 2);
        }
        this.hasData[this.level] = false;
        this.lists[this.level] = list;
    }

    private void decreaseLevel() throws IOException {
        --this.level;
    }

    private void startWrite() throws IOException {
        this.hasData[this.level] = true;
    }

    private boolean shouldOutputName() {
        return this.level != 0 && !this.lists[this.level];
    }

    private void writeName(String name) throws IOException {
        if (this.shouldOutputName()) {
            this.out.write(0);
            this.writeStringNoTag(name);
        }
    }

    private void writeIntegerNoTag(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) break;
            this.out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.out.write(value);
    }

    private void writeInteger(int value) throws IOException {
        if (value < 0) {
            this.out.write(20);
            this.writeIntegerNoTag(-value);
        } else {
            this.out.write(18);
            this.writeIntegerNoTag(value);
        }
    }

    private void writeLongNoTag(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.out.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.out.write((int)value);
    }

    private void writeLong(long value) throws IOException {
        if (value < 0L) {
            this.out.write(21);
            this.writeLongNoTag(-value);
        } else {
            this.out.write(19);
            this.writeLongNoTag(value);
        }
    }

    private void writeStringNoTag(String value) throws IOException {
        this.writeIntegerNoTag(value.length());
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (c <= '\u007f') {
                this.out.write((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.out.write((byte)(0xE0 | c >> 12 & 0xF));
                this.out.write((byte)(0x80 | c >> 6 & 0x3F));
                this.out.write((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.out.write((byte)(0xC0 | c >> 6 & 0x1F));
            this.out.write((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    private void writeString(String value) throws IOException {
        this.out.write(10);
        this.writeStringNoTag(value);
    }

    private void writeNull() throws IOException {
        this.out.write(13);
    }

    private void writeFloat(float value) throws IOException {
        this.out.write(14);
        int i = Float.floatToRawIntBits(value);
        this.out.write(i & 0xFF);
        this.out.write(i >> 8 & 0xFF);
        this.out.write(i >> 16 & 0xFF);
        this.out.write(i >> 24 & 0xFF);
    }

    private void writeDouble(double value) throws IOException {
        this.out.write(15);
        long l = Double.doubleToRawLongBits(value);
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >> 8) & 0xFF);
        this.out.write((int)(l >> 16) & 0xFF);
        this.out.write((int)(l >> 24) & 0xFF);
        this.out.write((int)(l >> 32) & 0xFF);
        this.out.write((int)(l >> 40) & 0xFF);
        this.out.write((int)(l >> 48) & 0xFF);
        this.out.write((int)(l >> 56) & 0xFF);
    }

    private void writeBoolean(boolean b) throws IOException {
        this.out.write(16);
        this.out.write(b ? 1 : 0);
    }

    private void writeByteArray(byte[] data) throws IOException {
        this.out.write(17);
        this.writeIntegerNoTag(data.length);
        this.out.write(data);
    }

    @Override
    public void writeObjectStart(String name) throws IOException {
        this.startWrite();
        this.writeName(name);
        this.out.write(1);
        this.increaseLevel(false);
    }

    @Override
    public void writeObjectEnd(String name) throws IOException {
        this.decreaseLevel();
        this.out.write(2);
    }

    @Override
    public void writeListStart(String name) throws IOException {
        this.startWrite();
        this.writeName(name);
        this.out.write(3);
        this.increaseLevel(true);
    }

    @Override
    public void writeListEnd(String name) throws IOException {
        this.decreaseLevel();
        this.out.write(4);
    }

    @Override
    public void write(String name, String value) throws IOException {
        this.startWrite();
        this.writeName(name);
        if (value == null) {
            this.writeNull();
        } else {
            this.writeString(value);
        }
    }

    @Override
    public void write(String name, int number) throws IOException {
        this.startWrite();
        this.writeName(name);
        this.writeInteger(number);
    }

    @Override
    public void write(String name, long number) throws IOException {
        this.startWrite();
        this.writeName(name);
        this.writeLong(number);
    }

    @Override
    public void write(String name, float number) throws IOException {
        this.startWrite();
        this.writeName(name);
        this.writeFloat(number);
    }

    @Override
    public void write(String name, double number) throws IOException {
        this.startWrite();
        this.writeName(name);
        this.writeDouble(number);
    }

    @Override
    public void write(String name, boolean bool) throws IOException {
        this.startWrite();
        this.writeName(name);
        this.writeBoolean(bool);
    }

    @Override
    public void write(String name, byte[] data) throws IOException {
        this.startWrite();
        this.writeName(name);
        this.writeByteArray(data);
    }

    @Override
    public void writeNull(String name) throws IOException {
        this.writeName(name);
        this.writeNull();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

