/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.enums;

import se.l4.commons.serialization.enums.ValueTranslator;
import se.l4.commons.serialization.format.ValueType;

public class OrdinalTranslator
implements ValueTranslator<Integer> {
    private final Enum<?>[] values;

    public OrdinalTranslator(Class<? extends Enum<?>> type) {
        this.values = type.getEnumConstants();
    }

    @Override
    public ValueType getType() {
        return ValueType.INTEGER;
    }

    @Override
    public Integer fromEnum(Enum<?> value) {
        return value.ordinal();
    }

    @Override
    public Enum<?> toEnum(Integer value) {
        int v = value;
        if (v >= 0 && v < this.values.length) {
            return this.values[v];
        }
        return null;
    }
}

