/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.enums;

import java.io.IOException;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.enums.ValueTranslator;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;
import se.l4.commons.serialization.internal.SerializerFormatDefinitionBuilderImpl;

public class EnumSerializer<T extends Enum<T>>
implements Serializer<T> {
    private final ValueTranslator translator;
    private final SerializerFormatDefinition formatDefinition;

    public EnumSerializer(ValueTranslator translator) {
        this.translator = translator;
        this.formatDefinition = new SerializerFormatDefinitionBuilderImpl().value(translator.getType()).build();
    }

    @Override
    public T read(StreamingInput in) throws IOException {
        Object value;
        in.next(Token.VALUE);
        switch (this.translator.getType()) {
            case BOOLEAN: {
                value = in.getBoolean();
                break;
            }
            case DOUBLE: {
                value = in.getDouble();
                break;
            }
            case FLOAT: {
                value = Float.valueOf(in.getFloat());
                break;
            }
            case INTEGER: {
                value = in.getInt();
                break;
            }
            case LONG: {
                value = in.getLong();
                break;
            }
            case SHORT: {
                value = in.getShort();
                break;
            }
            case STRING: {
                value = in.getString();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type: " + (Object)((Object)this.translator.getType())));
            }
        }
        return (T)this.translator.toEnum(value);
    }

    @Override
    public void write(T object, String name, StreamingOutput stream) throws IOException {
        Object value = this.translator.fromEnum((Enum<?>)object);
        switch (this.translator.getType()) {
            case BOOLEAN: {
                stream.write(name, (Boolean)value);
                break;
            }
            case DOUBLE: {
                stream.write(name, (Double)value);
                break;
            }
            case FLOAT: {
                stream.write(name, ((Float)value).floatValue());
                break;
            }
            case INTEGER: {
                stream.write(name, (Integer)value);
                break;
            }
            case LONG: {
                stream.write(name, (Long)value);
                break;
            }
            case SHORT: {
                stream.write(name, ((Short)value).shortValue());
                break;
            }
            case STRING: {
                stream.write(name, (String)value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type: " + (Object)((Object)this.translator.getType())));
            }
        }
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        return this.formatDefinition;
    }
}

