/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import se.l4.commons.serialization.AbstractSerializerCollection;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerCollection;
import se.l4.commons.serialization.collections.ListSerializerResolver;
import se.l4.commons.serialization.collections.MapSerializerResolver;
import se.l4.commons.serialization.collections.SetSerializerResolver;
import se.l4.commons.serialization.enums.EnumSerializerResolver;
import se.l4.commons.serialization.spi.DefaultInstanceFactory;
import se.l4.commons.serialization.spi.InstanceFactory;
import se.l4.commons.serialization.spi.NamingCallback;
import se.l4.commons.serialization.spi.SerializerResolver;
import se.l4.commons.serialization.spi.SerializerResolverRegistry;
import se.l4.commons.serialization.standard.BooleanSerializer;
import se.l4.commons.serialization.standard.ByteArraySerializer;
import se.l4.commons.serialization.standard.DoubleSerializer;
import se.l4.commons.serialization.standard.FloatSerializer;
import se.l4.commons.serialization.standard.IntSerializer;
import se.l4.commons.serialization.standard.LongSerializer;
import se.l4.commons.serialization.standard.ShortSerializer;
import se.l4.commons.serialization.standard.StringSerializer;
import se.l4.commons.serialization.standard.UuidSerializer;

public class DefaultSerializerCollection
extends AbstractSerializerCollection {
    private final InstanceFactory instanceFactory;
    private final SerializerResolverRegistry resolverRegistry;

    public DefaultSerializerCollection() {
        this(new DefaultInstanceFactory());
    }

    public DefaultSerializerCollection(InstanceFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
        this.resolverRegistry = new SerializerResolverRegistry(instanceFactory, new NamingCallback(){

            @Override
            public void registerIfNamed(Class<?> from, Serializer<?> serializer) {
                DefaultSerializerCollection.this.registerIfNamed(from, serializer);
            }
        });
        this.bind(Boolean.class, new BooleanSerializer(), "", "boolean");
        this.bind(Float.class, new FloatSerializer(), "", "float");
        this.bind(Double.class, new DoubleSerializer(), "", "double");
        this.bind(Short.class, new ShortSerializer(), "", "short");
        this.bind(Integer.class, new IntSerializer(), "", "integer");
        this.bind(Long.class, new LongSerializer(), "", "long");
        this.bind(String.class, new StringSerializer(), "", "string");
        this.bind(byte[].class, new ByteArraySerializer(), "", "byte[]");
        this.bind(UUID.class, new UuidSerializer(), "", "uuid");
        this.bind(List.class, new ListSerializerResolver());
        this.bind(Map.class, new MapSerializerResolver());
        this.bind(Set.class, new SetSerializerResolver());
        this.bind(Enum.class, new EnumSerializerResolver());
    }

    @Override
    public InstanceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    @Override
    public <T> SerializerCollection bind(Class<T> type, SerializerResolver<? extends T> resolver) {
        this.resolverRegistry.bind(type, resolver);
        return this;
    }

    @Override
    public SerializerResolver<?> getResolver(Class<?> type) {
        return this.resolverRegistry.getResolver(type);
    }
}

