/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.promote.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PromoteUtils {
    public static final String GOAL_PREFIX = "promote:";
    static final String FILENAME = "promotable-artifacts.properties";
    public static final String RELEASE_VERSION = "releaseVersion";

    private PromoteUtils() {
    }

    static Map<String, String> toMap(Artifact artifact, String prefix, URI basePath) {
        prefix = PromoteUtils.fixPrefix(prefix);
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        output.put(prefix + "id", artifact.getId());
        output.put(prefix + "groupId", artifact.getGroupId());
        output.put(prefix + "artifactId", artifact.getArtifactId());
        output.put(prefix + "version", artifact.getVersion());
        if (artifact.getScope() != null) {
            output.put(prefix + "scope", artifact.getScope());
        }
        output.put(prefix + "type", artifact.getType());
        if (artifact.getClassifier() != null) {
            output.put(prefix + "classifier", artifact.getClassifier());
        }
        if (artifact.getFile() != null) {
            output.put(prefix + "file", PromoteUtils.relativize(basePath, artifact.getFile()));
        }
        output.put(prefix + "baseVersion", artifact.getBaseVersion());
        return output;
    }

    static List<Artifact> attachedArtifactsFromProperties(Properties props, URI basePath) {
        Artifact attachedArtifact;
        ArrayList<Artifact> output = new ArrayList<Artifact>();
        int i = 0;
        while ((attachedArtifact = PromoteUtils.fromProperties(props, "attached." + i, basePath)) != null) {
            output.add(attachedArtifact);
            ++i;
        }
        return output;
    }

    static Artifact fromProperties(Properties input, String prefix, URI basePath) {
        prefix = PromoteUtils.fixPrefix(prefix);
        if (input == null || !input.containsKey(prefix + "id")) {
            return null;
        }
        String groupId = input.getProperty(prefix + "groupId");
        String artifactId = input.getProperty(prefix + "artifactId");
        String version = input.getProperty(prefix + "version");
        String type = input.getProperty(prefix + "type");
        String scope = input.getProperty(prefix + "scope");
        String classifier = input.getProperty(prefix + "classifier");
        String relativePath = input.getProperty(prefix + "file");
        DefaultArtifact output = new DefaultArtifact(groupId, artifactId, version, scope, type, classifier, PromoteUtils.newHandler(type, relativePath));
        if (relativePath != null) {
            File path = new File(basePath != null ? basePath.resolve(relativePath).getPath() : relativePath);
            output.setFile(path);
        }
        return output;
    }

    private static String fixPrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        } else if (prefix.length() > 0 && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        return prefix;
    }

    private static ArtifactHandler newHandler(String type, String path) {
        String extension;
        String string = extension = path == null ? "" : FileUtils.extension((String)path);
        if (StringUtils.isBlank((String)type)) {
            type = extension;
        }
        DefaultArtifactHandler handler = new DefaultArtifactHandler(type);
        if (!StringUtils.isBlank((String)extension)) {
            handler.setExtension(extension);
        }
        return handler;
    }

    private static String relativize(URI basePath, File path) {
        return basePath != null ? basePath.relativize(path.toURI()).getPath() : path.getPath();
    }

    static File getPromotePropertiesFile(MavenProject project) {
        return new File(project.getBuild().getDirectory(), FILENAME);
    }

    static URI getTargetURI(MavenProject project) {
        String target = project.getBuild().getDirectory();
        return new File(target).toURI();
    }

    static void writeProperties(Log log, MavenProject project, Properties properties) throws MojoExecutionException {
        try {
            File file = PromoteUtils.getPromotePropertiesFile(project);
            if (file.getParentFile().mkdirs()) {
                log.debug((CharSequence)"Created missing target directory.");
            }
            log.info((CharSequence)("Writing artifact information to " + file));
            properties.store(new FileOutputStream(file), "Generated by promote-maven-plugin");
            log.debug((CharSequence)("Written artifact properties: " + properties));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing artifacts to file", (Exception)e);
        }
    }
}

