/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.promote.maven.plugin;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.config.PropertiesReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.codehaus.plexus.util.PropertyUtils;
import se.jiderhamn.promote.maven.plugin.PromoteUtils;

@Mojo(name="artifacts", requiresProject=true)
public class PromoteArtifactsMojo
extends AbstractMojo {
    public static final String NAME = "artifacts";
    @Parameter(property="project")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        File promotePropertiesFile = PromoteUtils.getPromotePropertiesFile(this.project);
        if (!promotePropertiesFile.exists()) {
            this.getLog().warn((CharSequence)("Cannot find " + promotePropertiesFile + ". Remember to run the " + "make-promotable" + " goal after building the artifacts."));
        }
        Properties props = PropertyUtils.loadProperties((File)promotePropertiesFile);
        this.getLog().info((CharSequence)("Artifact information read from " + promotePropertiesFile));
        this.getLog().debug((CharSequence)("Read properties: " + props));
        URI targetURI = PromoteUtils.getTargetURI(this.project);
        Artifact artifact = PromoteUtils.fromProperties(props, "artifact", targetURI);
        if (artifact != null) {
            this.validateArtifact(artifact);
            String releasedVersion = this.getReleasedVersion(this.project, artifact);
            this.getLog().info((CharSequence)("Setting artifact: " + artifact + "; released version " + releasedVersion));
            artifact.setVersion(releasedVersion != null ? releasedVersion : this.project.getVersion());
            artifact.setRelease(true);
            this.project.setArtifact(artifact);
        }
        List<Artifact> attachedArtifacts = PromoteUtils.attachedArtifactsFromProperties(props, targetURI);
        for (Artifact attachedArtifact : attachedArtifacts) {
            this.validateArtifact(attachedArtifact);
            String releasedVersion = this.getReleasedVersion(this.project, attachedArtifact);
            this.getLog().info((CharSequence)("Attaching artifact: " + attachedArtifact + "; released version " + releasedVersion));
            attachedArtifact.setVersion(releasedVersion != null ? releasedVersion : this.project.getVersion());
            attachedArtifact.setRelease(true);
            this.project.addAttachedArtifact(attachedArtifact);
        }
    }

    private void validateArtifact(Artifact artifact) {
        File file = artifact.getFile();
        if (file == null) {
            this.getLog().error((CharSequence)("No file registered for artifact: " + artifact));
        } else if (!file.exists()) {
            this.getLog().error((CharSequence)("File for artifact " + artifact + " does not exist: " + file));
        }
    }

    private String getReleasedVersion(MavenProject project, Artifact artifact) throws MojoExecutionException {
        if (project == null || project.getBasedir() == null) {
            throw new MojoExecutionException("Basedir must be provided for project " + project);
        }
        String key = ArtifactUtils.versionlessKey((Artifact)artifact);
        try {
            PropertiesReleaseDescriptorStore descriptorStore = new PropertiesReleaseDescriptorStore();
            ReleaseDescriptor releaseDescriptor = new ReleaseDescriptor();
            releaseDescriptor.setWorkingDirectory(project.getBasedir().getAbsolutePath());
            releaseDescriptor = descriptorStore.read(releaseDescriptor);
            Map releaseVersions = releaseDescriptor.getReleaseVersions();
            this.getLog().debug((CharSequence)("Read versions from " + project.getBasedir() + ": " + releaseVersions));
            if (releaseVersions.containsKey(key)) {
                return (String)releaseVersions.get(key);
            }
        }
        catch (ReleaseDescriptorStoreException e) {
            throw new MojoExecutionException("Error parsing release descriptor", (Exception)((Object)e));
        }
        catch (NullPointerException e) {
            this.getLog().debug((CharSequence)"Error finding release descriptor", (Throwable)e);
        }
        if (project.hasParent() && project.getParent().getBasedir() != null) {
            this.getLog().debug((CharSequence)("No version for " + key + " found in " + project + "; looking in parent "));
            return this.getReleasedVersion(project.getParent(), artifact);
        }
        return null;
    }
}

