/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.promote.maven.plugin;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.PropertyUtils;
import se.jiderhamn.promote.maven.plugin.PromoteUtils;

@Mojo(name="make-promotable", requiresProject=true, defaultPhase=LifecyclePhase.PACKAGE)
public class MakePromotableMojo
extends AbstractMojo {
    public static final String NAME = "make-promotable";
    @Parameter(property="project")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Artifact artifact;
        URI targetURI = PromoteUtils.getTargetURI(this.project);
        ArrayList attachedArtifacts = this.project.getAttachedArtifacts();
        Properties artifactInfo = new Properties();
        int firstAttachedArtifactIndex = 0;
        File promotePropertiesFile = PromoteUtils.getPromotePropertiesFile(this.project);
        if (promotePropertiesFile.exists()) {
            artifactInfo = PropertyUtils.loadProperties((File)promotePropertiesFile);
            this.getLog().info((CharSequence)("Existing artifact information read from " + promotePropertiesFile));
            this.getLog().debug((CharSequence)("Read properties: " + artifactInfo));
            List<Artifact> previouslyAttachedArtifacts = PromoteUtils.attachedArtifactsFromProperties(artifactInfo, targetURI);
            firstAttachedArtifactIndex = previouslyAttachedArtifacts.size();
            attachedArtifacts = new ArrayList(attachedArtifacts);
            attachedArtifacts.removeAll(previouslyAttachedArtifacts);
        }
        if ((artifact = this.project.getArtifact()) != null) {
            this.getLog().info((CharSequence)("Artifact: " + artifact.getId()));
            Map<String, String> artifactProperties = PromoteUtils.toMap(artifact, "artifact", targetURI);
            this.getLog().debug((CharSequence)("Artifact properties: " + artifactProperties));
            artifactInfo.putAll(artifactProperties);
        } else {
            this.getLog().debug((CharSequence)"No main artifact found");
        }
        if (!attachedArtifacts.isEmpty()) {
            for (int i = 0; i < attachedArtifacts.size(); ++i) {
                Artifact attachedArtifact = (Artifact)attachedArtifacts.get(i);
                this.getLog().info((CharSequence)("Attached artifact: " + attachedArtifact.getId()));
                Map<String, String> artifactProperties = PromoteUtils.toMap(attachedArtifact, "attached." + (i + firstAttachedArtifactIndex), targetURI);
                this.getLog().debug((CharSequence)("Attached artifact properties: " + artifactProperties));
                artifactInfo.putAll(artifactProperties);
            }
        }
        PromoteUtils.writeProperties(this.getLog(), this.project, artifactInfo);
    }
}

