/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.skb.interfaces.transformers.textformat;

import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.StringUtils;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;
import shadow.de.vandermeer.skb.interfaces.transformers.IsTransformer;

public interface String_To_Centered
extends IsTransformer<String, StrBuilder> {
    public static final int DEFAULT_LENGTH = 80;
    public static final char DEFAULT_RIGHT_PADDING_CHARACTER = ' ';
    public static final char DEFAULT_LEFT_PADDING_CHARACTER = ' ';
    public static final char DEFAULT_INNER_WHITESPACE_CHARACTER = ' ';

    default public int getLength() {
        return 80;
    }

    default public Character getInnerWsChar() {
        return Character.valueOf(' ');
    }

    default public Character getRightPaddingChar() {
        return Character.valueOf(' ');
    }

    default public Character getLeftPaddingChar() {
        return Character.valueOf(' ');
    }

    default public StrBuilder getBuilderForAppend() {
        return null;
    }

    @Override
    default public StrBuilder transform(String s) {
        int i;
        IsTransformer.super.transform(s);
        StrBuilder ret = this.getBuilderForAppend() == null ? new StrBuilder(this.getLength()) : this.getBuilderForAppend();
        String center = s == null ? "" : s;
        center = center.replace(' ', this.getInnerWsChar().charValue());
        char[] car = StringUtils.center(center, this.getLength()).toCharArray();
        for (i = car.length - 1; i > 0 && car[i] == ' '; --i) {
            car[i] = this.getRightPaddingChar().charValue();
        }
        for (i = 0; i < car.length && car[i] == ' '; ++i) {
            car[i] = this.getLeftPaddingChar().charValue();
        }
        ret.append(car);
        return ret;
    }

    public static String_To_Centered create(final int length, final Character leftPaddingChar, final Character rightPaddingChar, final Character innerWsChar, final StrBuilder builder) {
        Validate.validState(length > 0, "cannot work with lenght of less than 1", new Object[0]);
        return new String_To_Centered(){

            @Override
            public Character getInnerWsChar() {
                return innerWsChar == null ? String_To_Centered.super.getInnerWsChar() : innerWsChar;
            }

            @Override
            public int getLength() {
                return length < 1 ? String_To_Centered.super.getLength() : length;
            }

            @Override
            public Character getLeftPaddingChar() {
                return leftPaddingChar == null ? String_To_Centered.super.getLeftPaddingChar() : leftPaddingChar;
            }

            @Override
            public Character getRightPaddingChar() {
                return rightPaddingChar == null ? String_To_Centered.super.getRightPaddingChar() : rightPaddingChar;
            }

            @Override
            public StrBuilder getBuilderForAppend() {
                return builder;
            }
        };
    }

    public static StrBuilder convert(String s, int length) {
        return String_To_Centered.create(length, null, null, null, null).transform(s);
    }

    public static StrBuilder convert(String s, int length, StrBuilder builder) {
        return String_To_Centered.create(length, null, null, null, builder).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character paddingChar) {
        return String_To_Centered.create(length, paddingChar, paddingChar, null, null).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character paddingChar, StrBuilder builder) {
        return String_To_Centered.create(length, paddingChar, paddingChar, null, builder).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character leftPaddingChar, Character rightPaddingChar) {
        return String_To_Centered.create(length, leftPaddingChar, rightPaddingChar, null, null).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character leftPaddingChar, Character rightPaddingChar, Character innerWsChar) {
        return String_To_Centered.create(length, leftPaddingChar, rightPaddingChar, innerWsChar, null).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character leftPaddingChar, Character rightPaddingChar, StrBuilder builder) {
        return String_To_Centered.create(length, leftPaddingChar, rightPaddingChar, null, builder).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character leftPaddingChar, Character rightPaddingChar, Character innerWsChar, StrBuilder builder) {
        return String_To_Centered.create(length, leftPaddingChar, rightPaddingChar, innerWsChar, builder).transform(s);
    }
}

