/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk;

import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.Generator;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevFlag;

abstract class AbstractRevQueue
extends Generator {
    static final AbstractRevQueue EMPTY_QUEUE = new AlwaysEmptyQueue();
    int outputType;

    AbstractRevQueue(boolean firstParent) {
        super(firstParent);
    }

    public abstract void add(RevCommit var1);

    public final void add(RevCommit c, RevFlag queueControl) {
        if (!c.has(queueControl)) {
            c.add(queueControl);
            this.add(c);
        }
    }

    public final void addParents(RevCommit c, RevFlag queueControl) {
        RevCommit[] pList = c.parents;
        if (pList == null) {
            return;
        }
        int i = 0;
        while (i < pList.length) {
            if (this.firstParent && i > 0) break;
            this.add(pList[i], queueControl);
            ++i;
        }
    }

    @Override
    public abstract RevCommit next();

    public abstract void clear();

    abstract boolean everbodyHasFlag(int var1);

    abstract boolean anybodyHasFlag(int var1);

    @Override
    int outputType() {
        return this.outputType;
    }

    protected static void describe(StringBuilder s, RevCommit c) {
        s.append(c.toString());
        s.append('\n');
    }

    private static class AlwaysEmptyQueue
    extends AbstractRevQueue {
        private AlwaysEmptyQueue() {
            super(false);
        }

        @Override
        public void add(RevCommit c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RevCommit next() {
            return null;
        }

        @Override
        boolean anybodyHasFlag(int f) {
            return false;
        }

        @Override
        boolean everbodyHasFlag(int f) {
            return true;
        }

        @Override
        public void clear() {
        }
    }
}

