/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.patch;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.diff.DiffEntry;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AbbreviatedObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Constants;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.FileMode;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.patch.CombinedHunkHeader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.patch.FileHeader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.patch.HunkHeader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.RawParseUtils;

public class CombinedFileHeader
extends FileHeader {
    private static final byte[] MODE = Constants.encodeASCII("mode ");
    private AbbreviatedObjectId[] oldIds;
    private FileMode[] oldModes;

    CombinedFileHeader(byte[] b, int offset) {
        super(b, offset);
    }

    public List<? extends CombinedHunkHeader> getHunks() {
        return super.getHunks();
    }

    @Override
    public int getParentCount() {
        return this.oldIds.length;
    }

    @Override
    public FileMode getOldMode() {
        return this.getOldMode(0);
    }

    public FileMode getOldMode(int nthParent) {
        return this.oldModes[nthParent];
    }

    @Override
    public AbbreviatedObjectId getOldId() {
        return this.getOldId(0);
    }

    public AbbreviatedObjectId getOldId(int nthParent) {
        return this.oldIds[nthParent];
    }

    @Override
    public String getScriptText(Charset ocs, Charset ncs) {
        Object[] cs = new Charset[this.getParentCount() + 1];
        Arrays.fill(cs, ocs);
        cs[this.getParentCount()] = ncs;
        return this.getScriptText((Charset[])cs);
    }

    @Override
    public String getScriptText(Charset[] charsetGuess) {
        return super.getScriptText(charsetGuess);
    }

    @Override
    int parseGitHeaders(int ptr, int end) {
        while (ptr < end) {
            int eol = RawParseUtils.nextLF(this.buf, ptr);
            if (CombinedFileHeader.isHunkHdr(this.buf, ptr, end) >= 1) break;
            if (RawParseUtils.match(this.buf, ptr, OLD_NAME) >= 0) {
                this.parseOldName(ptr, eol);
            } else if (RawParseUtils.match(this.buf, ptr, NEW_NAME) >= 0) {
                this.parseNewName(ptr, eol);
            } else if (RawParseUtils.match(this.buf, ptr, INDEX) >= 0) {
                this.parseIndexLine(ptr + INDEX.length, eol);
            } else if (RawParseUtils.match(this.buf, ptr, MODE) >= 0) {
                this.parseModeLine(ptr + MODE.length, eol);
            } else if (RawParseUtils.match(this.buf, ptr, NEW_FILE_MODE) >= 0) {
                this.parseNewFileMode(ptr, eol);
            } else {
                if (RawParseUtils.match(this.buf, ptr, DELETED_FILE_MODE) < 0) break;
                this.parseDeletedFileMode(ptr + DELETED_FILE_MODE.length, eol);
            }
            ptr = eol;
        }
        return ptr;
    }

    @Override
    protected void parseIndexLine(int ptr, int eol) {
        ArrayList<AbbreviatedObjectId> ids = new ArrayList<AbbreviatedObjectId>();
        while (ptr < eol) {
            int comma = RawParseUtils.nextLF(this.buf, ptr, ',');
            if (eol <= comma) break;
            ids.add(AbbreviatedObjectId.fromString(this.buf, ptr, comma - 1));
            ptr = comma;
        }
        this.oldIds = new AbbreviatedObjectId[ids.size() + 1];
        ids.toArray(this.oldIds);
        int dot2 = RawParseUtils.nextLF(this.buf, ptr, '.');
        this.oldIds[ids.size()] = AbbreviatedObjectId.fromString(this.buf, ptr, dot2 - 1);
        this.newId = AbbreviatedObjectId.fromString(this.buf, dot2 + 1, eol - 1);
        this.oldModes = new FileMode[this.oldIds.length];
    }

    @Override
    protected void parseNewFileMode(int ptr, int eol) {
        int i = 0;
        while (i < this.oldModes.length) {
            this.oldModes[i] = FileMode.MISSING;
            ++i;
        }
        super.parseNewFileMode(ptr, eol);
    }

    @Override
    HunkHeader newHunkHeader(int offset) {
        return new CombinedHunkHeader(this, offset);
    }

    private void parseModeLine(int ptr, int eol) {
        int n = 0;
        while (ptr < eol) {
            int comma = RawParseUtils.nextLF(this.buf, ptr, ',');
            if (eol <= comma) break;
            this.oldModes[n++] = this.parseFileMode(ptr, comma);
            ptr = comma;
        }
        int dot2 = RawParseUtils.nextLF(this.buf, ptr, '.');
        this.oldModes[n] = this.parseFileMode(ptr, dot2);
        this.newMode = this.parseFileMode(dot2 + 1, eol);
    }

    private void parseDeletedFileMode(int ptr, int eol) {
        this.changeType = DiffEntry.ChangeType.DELETE;
        int n = 0;
        while (ptr < eol) {
            int comma = RawParseUtils.nextLF(this.buf, ptr, ',');
            if (eol <= comma) break;
            this.oldModes[n++] = this.parseFileMode(ptr, comma);
            ptr = comma;
        }
        this.oldModes[n] = this.parseFileMode(ptr, eol);
        this.newMode = FileMode.MISSING;
    }
}

