/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AnyObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectIdSet;

public class ObjectIdOwnerMap<V extends Entry>
implements Iterable<V>,
ObjectIdSet {
    private static final int INITIAL_DIRECTORY = 1024;
    private static final int SEGMENT_BITS = 11;
    private static final int SEGMENT_SHIFT = 21;
    V[][] directory;
    int size;
    private int grow = ObjectIdOwnerMap.computeGrowAt(this.bits);
    int bits = 0;
    private int mask = 0;

    public ObjectIdOwnerMap() {
        this.directory = new Entry[1024][];
        this.directory[0] = this.newSegment();
    }

    public void clear() {
        this.size = 0;
        V[][] VArray = this.directory;
        int n = this.directory.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] tbl = VArray[n2];
            if (tbl == null) break;
            Arrays.fill(tbl, null);
            ++n2;
        }
    }

    public V get(AnyObjectId toFind) {
        if (toFind == null) {
            return null;
        }
        int h = toFind.w1;
        Object obj = this.directory[h & this.mask][h >>> 21];
        while (obj != null) {
            if (ObjectIdOwnerMap.equals(obj, toFind)) {
                return obj;
            }
            obj = ((Entry)obj).next;
        }
        return null;
    }

    @Override
    public boolean contains(AnyObjectId toFind) {
        return this.get(toFind) != null;
    }

    public <Q extends V> void add(Q newValue) {
        if (++this.size == this.grow) {
            this.grow();
        }
        int h = ((Entry)newValue).w1;
        V[] table = this.directory[h & this.mask];
        ((Entry)newValue).next = table[h >>>= 21];
        table[h] = newValue;
    }

    public <Q extends V> V addIfAbsent(Q newValue) {
        int h = ((Entry)newValue).w1;
        V[] table = this.directory[h & this.mask];
        Object obj = table[h >>>= 21];
        while (obj != null) {
            if (ObjectIdOwnerMap.equals(obj, newValue)) {
                return obj;
            }
            obj = ((Entry)obj).next;
        }
        ((Entry)newValue).next = table[h];
        table[h] = newValue;
        if (++this.size == this.grow) {
            this.grow();
        }
        return newValue;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private int found;
            private int dirIdx;
            private int tblIdx;
            private V next;

            @Override
            public boolean hasNext() {
                return this.found < ObjectIdOwnerMap.this.size;
            }

            @Override
            public V next() {
                Object v;
                if (this.next != null) {
                    return this.found(this.next);
                }
                block0: while (true) {
                    V[] table;
                    if (this.tblIdx == (table = ObjectIdOwnerMap.this.directory[this.dirIdx]).length) {
                        if (++this.dirIdx >= 1 << ObjectIdOwnerMap.this.bits) {
                            throw new NoSuchElementException();
                        }
                        table = ObjectIdOwnerMap.this.directory[this.dirIdx];
                        this.tblIdx = 0;
                    }
                    do {
                        if (this.tblIdx >= table.length) continue block0;
                    } while ((v = table[this.tblIdx++]) == null);
                    break;
                }
                return this.found(v);
            }

            private V found(V v) {
                ++this.found;
                this.next = ((Entry)v).next;
                return v;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void grow() {
        int oldDirLen = 1 << this.bits;
        int s = 1 << this.bits;
        ++this.bits;
        this.mask = (1 << this.bits) - 1;
        this.grow = ObjectIdOwnerMap.computeGrowAt(this.bits);
        int newDirLen = 1 << this.bits;
        if (this.directory.length < newDirLen) {
            Entry[][] newDir = new Entry[newDirLen << 1][];
            System.arraycopy(this.directory, 0, newDir, 0, oldDirLen);
            this.directory = newDir;
        }
        int dirIdx = 0;
        while (dirIdx < oldDirLen) {
            V[] oldTable = this.directory[dirIdx];
            Entry[] newTable = this.newSegment();
            int i = 0;
            while (i < oldTable.length) {
                Object chain0 = null;
                Object chain1 = null;
                Object obj = oldTable[i];
                while (obj != null) {
                    Entry next = ((Entry)obj).next;
                    if ((((Entry)obj).w1 & s) == 0) {
                        ((Entry)obj).next = chain0;
                        chain0 = obj;
                    } else {
                        ((Entry)obj).next = chain1;
                        chain1 = obj;
                    }
                    obj = next;
                }
                oldTable[i] = chain0;
                newTable[i] = chain1;
                ++i;
            }
            this.directory[oldDirLen + dirIdx] = newTable;
            ++dirIdx;
        }
    }

    private final V[] newSegment() {
        return new Entry[2048];
    }

    private static final int computeGrowAt(int bits) {
        return 1 << bits + 11;
    }

    private static final boolean equals(AnyObjectId firstObjectId, AnyObjectId secondObjectId) {
        return firstObjectId.w2 == secondObjectId.w2 && firstObjectId.w3 == secondObjectId.w3 && firstObjectId.w4 == secondObjectId.w4 && firstObjectId.w5 == secondObjectId.w5 && firstObjectId.w1 == secondObjectId.w1;
    }

    public static abstract class Entry
    extends ObjectId {
        transient Entry next;

        public Entry(AnyObjectId id) {
            super(id);
        }
    }
}

