/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.pack;

import java.util.concurrent.locks.ReentrantLock;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.pack.DeltaCache;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.storage.pack.PackConfig;

class ThreadSafeDeltaCache
extends DeltaCache {
    private final ReentrantLock lock = new ReentrantLock();

    ThreadSafeDeltaCache(PackConfig pc) {
        super(pc);
    }

    @Override
    boolean canCache(int length, ObjectToPack src, ObjectToPack res) {
        this.lock.lock();
        try {
            boolean bl = super.canCache(length, src, res);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    void credit(int reservedSize) {
        this.lock.lock();
        try {
            super.credit(reservedSize);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    DeltaCache.Ref cache(byte[] data, int actLen, int reservedSize) {
        data = this.resize(data, actLen);
        this.lock.lock();
        try {
            DeltaCache.Ref ref = super.cache(data, actLen, reservedSize);
            return ref;
        }
        finally {
            this.lock.unlock();
        }
    }
}

