/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache;

import java.io.IOException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCacheBuilder;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCacheIterator;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCacheTree;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.CorruptObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectReader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.AbstractTreeIterator;

public class DirCacheBuildIterator
extends DirCacheIterator {
    private final DirCacheBuilder builder;

    public DirCacheBuildIterator(DirCacheBuilder dcb) {
        super(dcb.getDirCache());
        this.builder = dcb;
    }

    DirCacheBuildIterator(DirCacheBuildIterator p, DirCacheTree dct) {
        super(p, dct);
        this.builder = p.builder;
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheBuildIterator(this, this.currentSubtree);
    }

    @Override
    public void skip() throws CorruptObjectException {
        if (this.currentSubtree != null) {
            this.builder.keep(this.ptr, this.currentSubtree.getEntrySpan());
        } else {
            this.builder.keep(this.ptr, 1);
        }
        this.next(1);
    }

    @Override
    public void stopWalk() {
        int cur = this.ptr;
        int cnt = this.cache.getEntryCount();
        if (cur < cnt) {
            this.builder.keep(cur, cnt - cur);
        }
    }

    @Override
    protected boolean needsStopWalk() {
        return this.ptr < this.cache.getEntryCount();
    }
}

