/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors;

import java.text.MessageFormat;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;

public class FilterFailedException
extends GitAPIException {
    private static final long serialVersionUID = 1L;
    private String filterCommand;
    private String path;
    private byte[] stdout;
    private String stderr;
    private int rc;

    public FilterFailedException(Exception cause, String filterCommand, String path) {
        super(MessageFormat.format(JGitText.get().filterExecutionFailed, filterCommand, path), cause);
        this.filterCommand = filterCommand;
        this.path = path;
    }

    public FilterFailedException(int rc, String filterCommand, String path, byte[] stdout, String stderr) {
        super(MessageFormat.format(JGitText.get().filterExecutionFailedRc, filterCommand, path, rc, stderr));
        this.rc = rc;
        this.filterCommand = filterCommand;
        this.path = path;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public String getFilterCommand() {
        return this.filterCommand;
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getOutput() {
        return this.stdout;
    }

    public String getError() {
        return this.stderr;
    }

    public int getReturnCode() {
        return this.rc;
    }
}

