/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.codeclimate.CodeClimate;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateSeverity;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.violationslib.com.google.gson.Gson;
import se.bjurr.violations.violationslib.com.google.gson.reflect.TypeToken;

public class CodeClimateParser
implements ViolationsParser {
    private static final Type listType = new TypeToken<List<CodeClimate>>(){}.getType();

    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        List codeClimate = (List)new Gson().fromJson(string, listType);
        TreeSet<Violation> violations = new TreeSet<Violation>();
        for (CodeClimate issue : codeClimate) {
            if (issue.getSeverity() == null || issue.getCategories().size() == 0) {
                violationsLogger.log(Level.FINE, "Ignoring issue: " + issue);
                continue;
            }
            Integer begin = -1;
            if (issue.getLocation() != null && issue.getLocation().getLines() != null) {
                begin = issue.getLocation().getLines().getBegin();
            }
            if (issue.getLocation() != null && issue.getLocation().getPositions() != null && issue.getLocation().getPositions().getBegin() != null) {
                begin = issue.getLocation().getPositions().getBegin().getLine();
            }
            if (begin == -1) {
                violationsLogger.log(Level.FINE, "Ignoring issue: " + issue);
                continue;
            }
            violations.add(Violation.violationBuilder().setFile(issue.getLocation().getPath()).setCategory(issue.getCategories().get(0).getName()).setMessage(issue.getDescription()).setParser(Parser.CODECLIMATE).setReporter(issue.getEngine_name()).setRule(issue.getCheck_name()).setSeverity(this.toSeverity(issue.getSeverity())).setStartLine(begin).build());
        }
        return violations;
    }

    private SEVERITY toSeverity(CodeClimateSeverity severity) {
        if (severity == CodeClimateSeverity.blocker || severity == CodeClimateSeverity.critical || severity == CodeClimateSeverity.major) {
            return SEVERITY.ERROR;
        }
        if (severity == CodeClimateSeverity.minor) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

