/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CPDParser
implements ViolationsParser {
    private SEVERITY getSeverity(Integer from) {
        if (from < 100) {
            return SEVERITY.INFO;
        }
        if (from < 1000) {
            return SEVERITY.WARN;
        }
        return SEVERITY.ERROR;
    }

    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            ArrayList<String> files = new ArrayList<String>();
            ArrayList<Integer> filesLine = new ArrayList<Integer>();
            Integer tokens = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("duplication")) {
                    tokens = ViolationParserUtils.getIntegerAttribute(xmlr, "tokens");
                }
                if (xmlr.getLocalName().equalsIgnoreCase("file")) {
                    files.add(ViolationParserUtils.getAttribute(xmlr, "path"));
                    filesLine.add(ViolationParserUtils.getIntegerAttribute(xmlr, "line"));
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("codefragment")) continue;
                String codefragment = xmlr.getElementText().trim();
                for (int i = 0; i < filesLine.size(); ++i) {
                    String file = (String)files.get(i);
                    Integer line = (Integer)filesLine.get(i);
                    Violation violation = Violation.violationBuilder().setParser(Parser.CPD).setFile(file).setMessage(codefragment).setRule("DUPLICATION").setSeverity(this.getSeverity(tokens)).setStartLine(line).build();
                    violations.add(violation);
                }
                files.clear();
                filesLine.clear();
            }
        }
        return violations;
    }
}

