/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.git;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import se.bjurr.violations.git.ViolationsReporterDetailLevel;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.table.ViolationsTable;

public class ViolationsReporterApi {
    private Iterable<Violation> violations;
    private int maxReporterColumnWidth;
    private int maxRuleColumnWidth = 10;
    private int maxSeverityColumnWidth;
    private int maxLineColumnWidth;
    private int maxMessageColumnWidth = 50;

    private ViolationsReporterApi() {
    }

    public static ViolationsReporterApi violationsReporterApi() {
        return new ViolationsReporterApi();
    }

    public String getReport(ViolationsReporterDetailLevel level) {
        Utils.checkNotNull(this.violations, "violations");
        StringBuilder sb = new StringBuilder();
        if (level == ViolationsReporterDetailLevel.COMPACT) {
            sb.append((CharSequence)this.toCompact(this.violations, "Summary"));
        } else if (level == ViolationsReporterDetailLevel.PER_FILE_COMPACT) {
            sb.append((CharSequence)this.toPerFile(this.violations));
            sb.append((CharSequence)this.toCompact(this.violations, "Summary"));
        } else if (level == ViolationsReporterDetailLevel.VERBOSE) {
            sb.append((CharSequence)this.toVerbose(this.violations));
            sb.append((CharSequence)this.toCompact(this.violations, "Summary"));
        }
        return sb.toString();
    }

    private StringBuilder toVerbose(Iterable<Violation> violations) {
        StringBuilder sb = new StringBuilder();
        Map<String, Set<Violation>> perFile = this.getViolationsPerFile(violations);
        for (Map.Entry<String, Set<Violation>> perFileEntry : perFile.entrySet()) {
            String file = perFileEntry.getKey();
            Set<Violation> fileViolations = perFile.get(file);
            sb.append(file + "\n");
            sb.append((CharSequence)this.toDetailed(fileViolations, "Summary of " + file));
            sb.append("\n");
        }
        return sb;
    }

    private StringBuilder toPerFile(Iterable<Violation> violations) {
        StringBuilder sb = new StringBuilder();
        Map<String, Set<Violation>> perFile = this.getViolationsPerFile(violations);
        for (Map.Entry<String, Set<Violation>> fileEntry : perFile.entrySet()) {
            Set<Violation> fileViolations = fileEntry.getValue();
            String fileName = fileEntry.getKey();
            sb.append((CharSequence)this.toCompact(fileViolations, "Summary of " + fileName));
            sb.append("\n");
        }
        return sb;
    }

    public ViolationsReporterApi withViolations(Set<Violation> violations) {
        this.violations = violations;
        return this;
    }

    public ViolationsReporterApi withMaxMessageColumnWidth(int maxMessageColumnWidth) {
        this.maxMessageColumnWidth = maxMessageColumnWidth;
        return this;
    }

    public ViolationsReporterApi withMaxLineColumnWidth(int maxLineColumnWidth) {
        this.maxLineColumnWidth = maxLineColumnWidth;
        return this;
    }

    public ViolationsReporterApi withMaxReporterColumnWidth(int maxReporterColumnWidth) {
        this.maxReporterColumnWidth = maxReporterColumnWidth;
        return this;
    }

    public ViolationsReporterApi withMaxRuleColumnWidth(int maxRuleColumnWidth) {
        this.maxRuleColumnWidth = maxRuleColumnWidth;
        return this;
    }

    public ViolationsReporterApi withMaxSeverityColumnWidth(int maxSeverityColumnWidth) {
        this.maxSeverityColumnWidth = maxSeverityColumnWidth;
        return this;
    }

    private StringBuilder toDetailed(Iterable<Violation> violations, String summarySubject) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (Violation violation : violations) {
            String message = this.nullToEmpty(violation.getMessage());
            String line = this.nullToEmpty(violation.getStartLine().toString());
            String severity = this.nullToEmpty(violation.getSeverity().name());
            String rule = this.nullToEmpty(violation.getRule());
            String reporter = this.nullToEmpty(violation.getReporter());
            String[] row = new String[]{reporter, rule, severity, line, message};
            rows.add(row);
        }
        String[] headers = new String[]{"Reporter", "Rule", "Severity", "Line", "Message"};
        String[][] data = (String[][])rows.toArray((T[])new String[0][]);
        int[] columnWidths = new int[]{this.zeroToMax(this.maxReporterColumnWidth), this.zeroToMax(this.maxRuleColumnWidth), this.zeroToMax(this.maxSeverityColumnWidth), this.zeroToMax(this.maxLineColumnWidth), this.zeroToMax(this.maxMessageColumnWidth)};
        sb.append(ViolationsTable.of(headers, data, columnWidths));
        sb.append("\n");
        sb.append((CharSequence)this.toCompact(violations, summarySubject));
        sb.append("\n");
        return sb;
    }

    private int zeroToMax(int i) {
        return i == 0 ? Integer.MAX_VALUE : i;
    }

    private String nullToEmpty(String message) {
        if (message == null) {
            return "";
        }
        return message.trim();
    }

    private StringBuilder toCompact(Iterable<Violation> violations, String subject) {
        StringBuilder sb = new StringBuilder();
        Map<String, Set<Violation>> perReporter = this.getViolationsPerReporter(violations);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        Integer totNumInfo = 0;
        Integer totNumWarn = 0;
        Integer totNumError = 0;
        Integer totNumTot = 0;
        for (Map.Entry<String, Set<Violation>> reporterEntry : perReporter.entrySet()) {
            String reporter = reporterEntry.getKey();
            Set<Violation> reporterViolations = reporterEntry.getValue();
            Map<SEVERITY, Set<Violation>> perSeverity = this.getViolationsPerSeverity(reporterViolations);
            Integer numInfo = perSeverity.get((Object)SEVERITY.INFO).size();
            Integer numWarn = perSeverity.get((Object)SEVERITY.WARN).size();
            Integer numError = perSeverity.get((Object)SEVERITY.ERROR).size();
            Integer numTot = numInfo + numWarn + numError;
            String[] row = new String[]{reporter, numInfo.toString(), numWarn.toString(), numError.toString(), numTot.toString()};
            rows.add(row);
            totNumInfo = totNumInfo + numInfo;
            totNumWarn = totNumWarn + numWarn;
            totNumError = totNumError + numError;
            totNumTot = totNumTot + numTot;
        }
        String[] row = new String[]{"", totNumInfo.toString(), totNumWarn.toString(), totNumError.toString(), totNumTot.toString()};
        rows.add(row);
        String[] headers = new String[]{"Reporter", SEVERITY.INFO.name(), SEVERITY.WARN.name(), SEVERITY.ERROR.name(), "Total"};
        String[][] data = (String[][])rows.toArray((T[])new String[0][]);
        sb.append(subject + "\n");
        int[] columnWidths = new int[]{};
        sb.append(ViolationsTable.of(headers, data, columnWidths));
        sb.append("\n");
        return sb;
    }

    private Map<SEVERITY, Set<Violation>> getViolationsPerSeverity(Set<Violation> violations) {
        TreeMap<SEVERITY, Set<Violation>> violationsPerSeverity = new TreeMap<SEVERITY, Set<Violation>>();
        for (SEVERITY severity : SEVERITY.values()) {
            violationsPerSeverity.put(severity, new TreeSet());
        }
        for (Violation violation : violations) {
            Set<Violation> perReporter = this.getOrCreate(violationsPerSeverity, violation.getSeverity());
            perReporter.add(violation);
        }
        return violationsPerSeverity;
    }

    private Map<String, Set<Violation>> getViolationsPerFile(Iterable<Violation> violations) {
        TreeMap<String, Set<Violation>> violationsPerFile = new TreeMap<String, Set<Violation>>();
        for (Violation violation : violations) {
            Set<Violation> perReporter = this.getOrCreate(violationsPerFile, violation.getFile());
            perReporter.add(violation);
        }
        return violationsPerFile;
    }

    private Map<String, Set<Violation>> getViolationsPerReporter(Iterable<Violation> violations) {
        TreeMap<String, Set<Violation>> violationsPerReporter = new TreeMap<String, Set<Violation>>();
        for (Violation violation : violations) {
            Set<Violation> perReporter = this.getOrCreate(violationsPerReporter, violation.getReporter());
            perReporter.add(violation);
        }
        return violationsPerReporter;
    }

    private <T, K> Set<T> getOrCreate(Map<K, Set<T>> container, K key) {
        if (container.containsKey(key)) {
            return container.get(key);
        }
        TreeSet violationList = new TreeSet();
        container.put(key, violationList);
        return violationList;
    }
}

