/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.git;

import java.io.File;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import se.bjurr.violations.git.ViolationsGitRepo;
import se.bjurr.violations.git.data.DiffsPerFile;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.util.PatchParserUtil;

public class ViolationsGit {
    private final Set<Violation> violations;
    private final ViolationsLogger logger;

    public ViolationsGit(ViolationsLogger logger, Set<Violation> violations) {
        this.violations = violations;
        this.logger = logger;
    }

    public Set<Violation> getViolationsInChangeset(File file, String from, String to) throws Exception {
        this.logger.log(Level.INFO, "Getting violations between " + from + " and " + to + " in " + file.getAbsolutePath());
        DiffsPerFile diffs = ViolationsGitRepo.diff(file, from, to);
        TreeSet<Violation> filtered = new TreeSet<Violation>();
        for (Violation candidate : this.violations) {
            Optional<String> patchStringOpt = diffs.findPatchString(candidate.getFile());
            this.logger.log(Level.INFO, "Checking if candidate " + candidate.getFile() + " is in diff");
            if (patchStringOpt.isPresent()) {
                Integer violatedLine;
                String patchString = patchStringOpt.get();
                if (new PatchParserUtil(patchString).isLineInDiff(violatedLine = candidate.getStartLine())) {
                    filtered.add(candidate);
                    continue;
                }
                this.logger.log(Level.INFO, "Violated line (" + violatedLine + ") in " + candidate.getFile() + " not found in patch: " + patchString);
                continue;
            }
            this.logger.log(Level.INFO, "Candidate not found in diff: " + candidate.getFile());
        }
        return filtered;
    }
}

